/* SccsId = "@(#)sys_incl.h 4.3 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#ifndef NOSYSINCL
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include "dmincl.h"
#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif
#endif

#line 1 "simple.cls"
/* <<cpre-2/8/82>> */ static char * SccsId = "@(#)simple.cls 4.7 (TU-Delft) 12/15/92" ; 
#line 1 "./sys_incl.h"

#line 41 "./sys_incl.h"

#line 28 "simple.cls"

#line 1 "./class.h"

#line 1 "./odb.h"

#line 31 "./class.h"
typedef struct datum 
{ 
char * dptr ; 
int dsize ; 
} datum ; 

typedef struct db_files { 
char * dbname ; 
int DbRdOnly ; 
int DirF , dir_b , dir_t ; 
int PagF , pag_b , pag_t ; 

long bitno ; 
long maxbno ; 
long blkno ; 
long hmask ; 

char pagbuf [ 1024 ] ; 
char dirbuf [ 1024 ] ; 
} DbAcces ; 

DbAcces * dbOpen ( ) ; 
datum dbfetch ( ) ; 
datum makdatum ( ) ; 
datum firstkey ( ) ; 
datum nextkey ( ) ; 
datum firsthash ( ) ; 
long calchash ( ) ; 
long hashinc ( ) ; 
#line 28 "./class.h"

#line 1 "./stack.h"

#line 27 "./stack.h"
struct stack { char * * min ;
char * * top ;
char * * max ;
} ;
extern int _1stack_new ( /* short */ ) ;
extern int _2stack_delete ( ) ;
extern int _13stack_empty ( /* ? */ ) ;
extern int _14stack_push ( /* char * */ ) ;
extern char * _15stack_pop ( ) ;
extern char * _16stack_access ( /* int */ ) ;
extern int _17stack_print ( ) ;
extern int _18stack_reset ( ) ;
extern struct stack * _19stack_copy ( ) ;
extern char * * _20stack_base ( ) ;
extern char * * _21stack_limit ( ) ;
extern int _22stack_length ( ) ;

#line 44 "./stack.h"
; 
#line 29 "./class.h"

#line 1 "./queue.h"

#line 27 "./queue.h"
struct link { struct link * next ;
char type ;
} ;

#line 31 "./queue.h"
;

#line 33 "./queue.h"
struct queue { struct link _Bqueue ;
struct link * tail ;
short n ;
} ;
extern int _1queue_new ( /* char */ ) ;
extern int _2queue_delete ( ) ;
extern int _12queue_reset ( ) ;
extern struct link * _13queue_get ( ) ;
extern int _14queue_put ( /* struct link * */ ) ;
extern short _15queue_length ( ) ;
extern int _16queue_print ( ) ;
extern int _17queue_empty ( ) ;
extern struct link * _18queue_access ( /* int */ ) ;
extern struct link * _19queue_first_elem ( ) ;
extern struct link * _20queue_next_elem ( /* struct link * */ ) ;
extern struct link * _21queue_last_elem ( ) ;
extern int _22queue_append ( /* struct queue * */ ) ;

#line 51 "./queue.h"
; 
#line 30 "./class.h"

#line 1 "./dict.h"

#line 27 "./dict.h"
struct dictionary { struct db_files * db ;
struct datum key ;
struct datum data ;
} ;
extern int _1dictionary_new ( ) ;
extern int _2dictionary_delete ( ) ;
extern int _13dictionary_store ( /* char * , char * */ ) ;
extern char * _14dictionary_fetch ( /* char * */ ) ;
extern int _15dictionary_print ( /* ? */ ) ;

#line 37 "./dict.h"
; 
#line 31 "./class.h"

typedef struct dictionary Dictionary ; 
typedef struct stack Stack ; 
typedef struct queue Queue ; 
typedef struct link Link ; 
#line 1 "./ntwdefs.h"

#line 27 "./ntwdefs.h"
struct ntwdef { int inst_gen_cnt ;
int net_gen_cnt ;
char * ntw_name ;
int local ;
struct queue * termq ;
struct queue * orig_termq ;
struct queue * mcq ;
struct queue * netq ;
} ;
extern int _1ntwdef_new ( /* char * */ ) ;
extern int _2ntwdef_delete ( ) ;
extern char * _12ntwdef_genname ( /* char */ ) ;

#line 40 "./ntwdefs.h"
;

#line 42 "./ntwdefs.h"
struct instancestruct { char * inst_name ;
struct stack * inst_construct ;
int termCnt ;
struct netMember * nmem ;
} ;
extern int _1instancestruct_new ( /* char * , struct stack * */ ) ;
extern int _2instancestruct_delete ( ) ;

#line 50 "./ntwdefs.h"
;

#line 52 "./ntwdefs.h"
struct ntwinst { struct link _Bntwinst ;
struct ntwdef * ntw ;
struct stack * ntw_attr ;
struct instancestruct * inst_struct ;
} ;
extern int _1ntwinst_new ( /* struct ntwdef * , struct stack * */ ) ;
extern int _2ntwinst_delete ( ) ;
extern int _13ntwinst_to_db ( ) ;

#line 60 "./ntwdefs.h"
; 


typedef struct ntwdef Network ; 
typedef struct ntwinst NetworkInstance ; 
typedef struct instancestruct InstanceStruct ; 
#line 38 "./class.h"

#line 1 "./xelem.h"

#line 27 "./xelem.h"
struct xelem { short left_bound ;
short right_bound ;
} ;
extern int _1xelem_new ( /* short , short */ ) ;
extern int _2xelem_delete ( ) ;
extern int _12xelem_print ( /* ? */ ) ;

#line 34 "./xelem.h"
; 
#line 39 "./class.h"

#line 1 "./netelem.h"

#line 31 "./netelem.h"
struct simpleNet { struct netMember * nmem ;
struct simpleNet * next ;
struct simpleNet * prev ;
} ;

#line 36 "./netelem.h"
;

#line 49 "./ntwdefs.h"
struct netMember { struct ntwinst * inst ;
struct netelem * net ;
struct netMember * next ;
struct simpleNet * snet ;
} ;

#line 44 "./netelem.h"
;

#line 41 "./netelem.h"
struct netelem { struct link _Bnetelem ;
char * name ;
int type ;
struct stack * xs ;
struct queue * eqv ;
struct netMember * nmem ;
} ;
extern int _1netelem_new ( /* char * , struct stack * , char */ ) ;
extern int _2netelem_delete ( ) ;
extern int _15netelem_print ( /* ? */ ) ;
extern int _16netelem_to_db ( /* ? */ ) ;

#line 57 "./netelem.h"
;

#line 59 "./netelem.h"
struct net_ref { struct link _Bnet_ref ;
struct netelem * net ;
struct stack * net_xs ;
struct ntwinst * inst ;
struct stack * inst_xs ;
struct stack * ref_xs ;
} ;
extern int _1net_ref_new ( /* struct netelem * , struct stack * */ ) ;
extern int _2net_ref_delete ( ) ;

#line 68 "./netelem.h"
; 

typedef struct netMember Nmem ; 
#line 40 "./class.h"

typedef struct xelem Xelem ; 
typedef struct netelem Netelem ; 
typedef struct net_ref NetReference ; 
#line 30 "simple.cls"

#line 1 "./mkdbdefs.h"

#line 1 "./slserr.h"

#line 30 "./mkdbdefs.h"

#line 31 "simple.cls"

#line 1 "./mkdbincl.h"

#line 27 "simple.cls"
extern int doSimpleNet ; 
extern int genIntNet ; 
extern int externRequired ; 
extern int forbidFirstCapital ; 
extern int noWarnings ; 
extern int sls_errcnt ; 
extern int sls_errno ; 
extern int sls_nerr ; 
extern char * sls_errlist [ ] ; 

extern int yylineno ; 
extern char fn_incl [ ] ; 

extern int int_nbyte , int_maxnbyte ; 
extern int char_nbyte , char_maxnbyte ; 
extern int ntwdef_nbyte , ntwdef_maxnbyte ; 
extern int ntwinst_nbyte , ntwinst_maxnbyte ; 
extern int inst_struct_nbyte , inst_struct_maxnbyte ; 
extern int netelem_nbyte , netelem_maxnbyte ; 
extern int dict_nbyte , dict_maxnbyte ; 
extern int net_ref_nbyte , net_ref_maxnbyte ; 
extern int xelem_nbyte , xelem_maxnbyte ; 
extern int queue_nbyte , queue_maxnbyte ; 
extern int stack_nbyte , stack_maxnbyte ; 
#line 32 "simple.cls"

extern Netelem * notconnected ; 
extern DM_STREAM * dsp_net ; 
extern Network * curr_ntw ; struct simpleNet 

* snetQueue = 0 ; 
int intNetCnt = 0 ; struct netMember 

* newNetMems ( ) ; 
int initCi ( ) ; 
int fillArrNet ( ) ; 

int joinSimple ( dnet , dnet_xs , inst , inst_xs , net , net_xs ) struct netelem * dnet ; struct stack * dnet_xs ; struct ntwinst * inst ; struct stack * inst_xs ; struct netelem * net ; struct stack * net_xs ; 
#line 51 "simple.cls"
{ int * _that ; 
int j ; 
int nbr ; 
Netelem * pterm ; 
Queue * termq ; 
int termq_len ; 
int dnet_off , inst_off , net_off ; struct netMember 
* net1mem , * net2mem ; struct netMember 
* net1memlast ; struct simpleNet 
* snet1 , * snet2 ; 
int dnet_ci [ 10 ] ; 
int inst_ci [ 10 ] ; 
int net_ci [ 10 ] ; 

if ( dnet -> nmem == 0 ) { 
 dnet -> nmem = ( struct netMember * ) ( newNetMems ( - 1 , ( struct ntwinst * ) 0 , dnet ) ) ; } 


if ( inst != 0 && inst -> inst_struct -> nmem == 0 ) { 

 termq = ( struct queue * ) ( inst -> ntw -> termq ) ; 
 termq_len = _15queue_length ( ( struct queue * ) termq ) ; 

 inst -> inst_struct -> termCnt = 0 ; 

for ( j = 0 , pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
j < termq_len ; 
 j ++ , pterm = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ) { 

 pterm -> nmem = ( struct netMember * ) ( inst -> inst_struct -> termCnt ) ; 

 inst -> inst_struct -> termCnt += getxslength ( pterm -> xs ) ; } 



 nbr = ( inst -> inst_struct -> termCnt ) * getxslength ( inst -> inst_struct -> inst_construct ) ; 

 inst -> inst_struct -> nmem = ( struct netMember * ) ( newNetMems ( nbr , inst , 0 ) ) ; } 


if ( inst == 0 && net -> nmem == 0 ) { 
 net -> nmem = ( struct netMember * ) ( newNetMems ( - 1 , ( struct ntwinst * ) 0 , net ) ) ; } 
#line 97 "simple.cls"
 initCi ( dnet_xs , dnet_ci ) ; 
 initCi ( inst_xs , inst_ci ) ; 
 initCi ( net_xs , net_ci ) ; 

do { 
 dnet_off = findOffset ( dnet -> xs , dnet_ci ) ; 
 net_off = findOffset ( net -> xs , net_ci ) ; 
if ( inst ) 

 inst_off = findOffset ( inst -> inst_struct -> inst_construct , inst_ci ) ; 

 net1mem = ( struct netMember * ) ( ( dnet -> nmem ) + dnet_off ) ; 
if ( inst ) 


 net2mem = ( struct netMember * ) ( ( inst -> inst_struct -> nmem ) + inst_off * inst -> inst_struct -> termCnt + ( int ) ( net -> nmem ) + net_off ) ; 
else 
 net2mem = ( struct netMember * ) ( ( net -> nmem ) + net_off ) ; 

 snet1 = ( struct simpleNet * ) ( net1mem -> snet ) ; 
 snet2 = ( struct simpleNet * ) ( net2mem -> snet ) ; 

if ( snet1 == snet2 ) 
continue ; 

 net1memlast = ( struct netMember * ) ( net1mem ) ; 
while ( net1memlast -> next ) 
 net1memlast = ( struct netMember * ) ( net1memlast -> next ) ; 

if ( snet2 ) { 
 net1memlast -> next = ( struct netMember * ) ( snet2 -> nmem ) ; 
 net1memlast = ( struct netMember * ) ( net1memlast -> next ) ; 
while ( net1memlast ) { 
 net1memlast -> snet = ( struct simpleNet * ) ( snet1 ) ; 
 net1memlast = ( struct netMember * ) ( net1memlast -> next ) ; } 


if ( snet2 -> prev ) 
 snet2 -> prev -> next = ( struct simpleNet * ) ( snet2 -> next ) ; 
else 
 snetQueue = ( struct simpleNet * ) ( snet2 -> next ) ; 
if ( snet2 -> next ) 
 snet2 -> next -> prev = ( struct simpleNet * ) ( snet2 -> prev ) ; } 

else { 
 net1memlast -> next = ( struct netMember * ) ( net2mem ) ; 
 net2mem -> snet = ( struct simpleNet * ) ( snet1 ) ; } 


if ( snet2 ) { _that = ( int * ) 
 snet2 ; free ( _that ) ; } } 

while ( 
 incrCi ( dnet_xs , dnet_ci ) && ( incrCi ( net_xs , net_ci ) || incrCi ( inst_xs , inst_ci ) ) ) ; } /* joinSimple */ struct netMember 



* newNetMems ( nr , inst , net ) int nr ; struct ntwinst * inst ; struct netelem * net ; 



{ int * _that ; struct netMember * _result ; 
int i ; struct netMember 
* ret ; struct netMember 
* r ; 
Queue * termq ; 
int termq_len ; 
int tlen ; 
int ilen ; 
int i_termNext ; 
Netelem * pterm ; 
Netelem * ptermNext ; 

if ( inst ) { 
 termq = ( struct queue * ) ( inst -> ntw -> termq ) ; 
 termq_len = _15queue_length ( ( struct queue * ) termq ) ; 
if ( termq_len > 0 ) { 
 pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; } 

else { 
 pterm = ( struct netelem * ) ( 0 ) ; } 

tlen = 1 ; 
if ( termq_len > 1 ) { 
 ptermNext = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ; 
 i_termNext = ( int ) ( ptermNext -> nmem ) ; 
tlen ++ ; } 

else { 
 ptermNext = ( struct netelem * ) ( 0 ) ; 
 i_termNext = inst -> inst_struct -> termCnt ; } 

ilen = 0 ; } 

else { 
 nr = getxslength ( net -> xs ) ; } 


 ret = ( struct netMember * ) calloc ( ( unsigned ) ( nr ) , sizeof ( struct netMember ) ) ; 
for ( i = 0 ; i < nr ; i ++ ) { 
 r = ( struct netMember * ) ( ret + i ) ; 
 r -> inst = ( struct ntwinst * ) ( inst ) ; 
 r -> next = ( struct netMember * ) ( 0 ) ; 
 r -> snet = ( struct simpleNet * ) calloc ( ( unsigned ) 1 , sizeof ( struct simpleNet ) ) ; 
 r -> snet -> nmem = ( struct netMember * ) ( r ) ; 
 r -> snet -> next = ( struct simpleNet * ) ( snetQueue ) ; 
if ( snetQueue ) { 
 snetQueue -> prev = ( struct simpleNet * ) ( r -> snet ) ; } 

 snetQueue = ( struct simpleNet * ) ( r -> snet ) ; 
 r -> snet -> prev = ( struct simpleNet * ) ( 0 ) ; 

if ( inst ) { 
if ( i >= i_termNext ) { 
 pterm = ( struct netelem * ) ( ptermNext ) ; 
if ( tlen >= termq_len ) { 
 ptermNext = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
tlen = 1 ; 
ilen ++ ; 
 i_termNext = ilen * inst -> inst_struct -> termCnt ; } 

else { 

 ptermNext = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) ptermNext ) ) ; 

 i_termNext = ilen * inst -> inst_struct -> termCnt + ( int ) ( ptermNext -> nmem ) ; 
tlen ++ ; } } 


 r -> net = ( struct netelem * ) ( pterm ) ; } 

else 
 r -> net = ( struct netelem * ) ( net ) ; } { _result = 


 ( ret ) ; goto _return ; } _return : return _result ; } /* newNetMems */ 


int initCi ( xs , ci ) struct stack * xs ; int * ci ; 


{ int * _that ; 
int i ; 
char * * pxs ; 
int lb , rb ; 

if ( xs ) { 
 i = _21stack_limit ( ( struct stack * ) xs ) - _20stack_base ( ( struct stack * ) xs ) ; 
 pxs = _21stack_limit ( ( struct stack * ) xs ) ; 

i -- ; 
pxs -- ; 
for ( ; i >= 0 ; i -- ) { 
 lb = ( ( struct xelem * ) * pxs ) -> left_bound ; 
 rb = ( ( struct xelem * ) * pxs ) -> right_bound ; 
if ( lb > rb ) 
ci [ i ] = rb ; 
else 
ci [ i ] = lb ; 
if ( i > 0 ) pxs -- ; } } } /* initCi */ 
#line 261 "simple.cls"
int incrCi ( xs , ci ) struct stack * xs ; int * ci ; 


{ int * _that ; int _result ; 
int i ; 
int n ; 
int offset ; 
int goOn ; 
char * * pxs ; 
int lb , rb ; 

if ( xs ) { 
 i = _21stack_limit ( ( struct stack * ) xs ) - _20stack_base ( ( struct stack * ) xs ) ; 
 pxs = _21stack_limit ( ( struct stack * ) xs ) ; 

i -- ; 
pxs -- ; 
goOn = 1 ; 
for ( ; i >= 0 && goOn ; i -- ) { 
 lb = ( ( struct xelem * ) * pxs ) -> left_bound ; 
 rb = ( ( struct xelem * ) * pxs ) -> right_bound ; 
if ( rb > lb ) { 
ci [ i ] ++ ; 
if ( ci [ i ] > rb ) 
ci [ i ] = lb ; 
else 
goOn = 0 ; } 

else { 
ci [ i ] -- ; 
if ( ci [ i ] < lb ) 
ci [ i ] = rb ; 
else 
goOn = 0 ; } 

if ( i > 0 ) pxs -- ; } 

if ( goOn ) { _result = 
 ( 0 ) ; goto _return ; } 
else { _result = 
 ( 1 ) ; goto _return ; } } 

else { _result = 
 ( 0 ) ; goto _return ; } _return : return _result ; } /* incrCi */ 


int findOffset ( xsdef , ci ) struct stack * xsdef ; int * ci ; 


{ int * _that ; int _result ; 
int i ; 
int n ; 
int offset ; 
int weight ; 
char * * pxs ; 
int lb , rb ; 

offset = 0 ; 

if ( xsdef ) { 
 i = _21stack_limit ( ( struct stack * ) xsdef ) - _20stack_base ( ( struct stack * ) xsdef ) ; 
 pxs = _21stack_limit ( ( struct stack * ) xsdef ) ; 

i -- ; 
pxs -- ; 
weight = 1 ; 
for ( ; i >= 0 ; i -- ) { 
 lb = ( ( struct xelem * ) * pxs ) -> left_bound ; 
 rb = ( ( struct xelem * ) * pxs ) -> right_bound ; 
if ( rb > lb ) { 
offset += ( ci [ i ] - lb ) * weight ; 
weight = weight * ( rb - lb + 1 ) ; } 

else { 
offset += ( ci [ i ] - rb ) * weight ; 
weight = weight * ( lb - rb + 1 ) ; } 

if ( i > 0 ) pxs -- ; } } { _result = 



 ( offset ) ; goto _return ; } _return : return _result ; } /* findOffset */ 


int outSimple ( q ) struct queue * q ; 

{ int * _that ; 
int i , 
j ; 
int nr ; 
int k ; struct simpleNet 
* snet ; struct simpleNet 
* snetOld ; struct netMember 
* otherMem ; struct netMember 
* eqvMem ; 
Netelem * pnet ; 
char * * pxs ; 

if ( ! _17queue_empty ( ( struct queue * ) q ) ) { 
for ( i = 0 , pnet = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) q ) ; 
 i < _15queue_length ( ( struct queue * ) q ) ; 
 i ++ , pnet = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) q , ( struct link * ) ( ( struct link * ) pnet ) ) ) { 

if ( 
 ! noWarnings && pnet != notconnected && pnet -> nmem == 0 && ( pnet -> type & 1 ) && ! ( pnet -> type & 2 ) ) 
fprintf ( stderr , 
"Warning: network %s, unconnected terminal %s\n" , 
 curr_ntw -> ntw_name , pnet -> name ) ; 

if ( pnet == notconnected || pnet -> xs == 0 ) 
continue ; 

strcpy ( cnet . net_name , pnet -> name ) ; 

if ( cnet . net_dim > 0 ) { { _that = ( int * ) 
 cnet . net_lower ; free ( _that ) ; } { _that = ( int * ) 
 cnet . net_upper ; free ( _that ) ; } } 


 cnet . net_dim = _21stack_limit ( ( struct stack * ) pnet -> xs ) - _20stack_base ( ( struct stack * ) pnet -> xs ) ; 

cnet . net_lower = ( long * ) calloc ( ( unsigned ) ( cnet . net_dim ) , sizeof ( long ) ) ; 
cnet . net_upper = ( long * ) calloc ( ( unsigned ) ( cnet . net_dim ) , sizeof ( long ) ) ; 

for ( j = 0 , pxs = _20stack_base ( ( struct stack * ) pnet -> xs ) ; 
 pxs < _21stack_limit ( ( struct stack * ) pnet -> xs ) ; 
j ++ , pxs ++ ) { 

 cnet . net_lower [ j ] = ( ( struct xelem * ) * pxs ) -> left_bound ; 
 cnet . net_upper [ j ] = ( ( struct xelem * ) * pxs ) -> right_bound ; } 


cnet . net_neqv = 0 ; 

dmPutDesignData ( dsp_net , CIR_NET ) ; } } 



 snet = ( struct simpleNet * ) ( snetQueue ) ; 
while ( snet != 0 ) { 

if ( snet -> nmem -> net != notconnected ) { 

if ( genIntNet && snet -> nmem -> net -> xs ) { 
sprintf ( cnet . net_name , "_N%d" , ++ intNetCnt ) ; 
if ( cnet . net_dim > 0 ) { { _that = ( int * ) 
 cnet . net_lower ; free ( _that ) ; } { _that = ( int * ) 
 cnet . net_upper ; free ( _that ) ; } } 

cnet . net_dim = 0 ; 
 eqvMem = ( struct netMember * ) ( snet -> nmem ) ; } 

else { 
strcpy ( cnet . net_name , snet -> nmem -> net -> name ) ; 
 fillArrNet ( & cnet , snet -> nmem , 0 ) ; 
 eqvMem = ( struct netMember * ) ( snet -> nmem -> next ) ; } 


 otherMem = ( struct netMember * ) ( eqvMem ) ; 
nr = 0 ; 
while ( otherMem ) { 
if ( otherMem -> net != notconnected ) 
nr ++ ; 
 otherMem = ( struct netMember * ) ( otherMem -> next ) ; } 


if ( cnet . net_neqv > 0 ) { _that = ( int * ) 
 cnet . net_eqv ; free ( _that ) ; } 

cnet . net_neqv = nr ; 
cnet . net_eqv = ( struct cir_net * ) calloc ( ( unsigned ) ( cnet . net_neqv ) , sizeof ( struct cir_net ) ) ; 

 otherMem = ( struct netMember * ) ( eqvMem ) ; 
i = 0 ; 
while ( otherMem ) { 

if ( otherMem -> net == notconnected ) { 
 otherMem = ( struct netMember * ) ( otherMem -> next ) ; 
continue ; } 


strcpy ( cnet . net_eqv [ i ] . net_name , otherMem -> net -> name ) ; 
if ( otherMem -> inst ) { 
strcpy ( cnet . net_eqv [ i ] . inst_name , 
 otherMem -> inst -> inst_struct -> inst_name ) ; } 

else { 
strcpy ( cnet . net_eqv [ i ] . inst_name , "" ) ; } 

 fillArrNet ( & cnet . net_eqv [ i ] , otherMem , & cnet ) ; 

 otherMem = ( struct netMember * ) ( otherMem -> next ) ; 

i ++ ; } 


if ( ! noWarnings && i < 1 ) { 
fprintf ( stderr , 
"Warning: network %s, unconnected terminal %s" , 
 curr_ntw -> ntw_name , cnet . net_name ) ; 
if ( cnet . net_dim > 0 ) { 
fprintf ( stderr , "[" ) ; 
for ( k = 0 ; k < cnet . net_dim ; k ++ ) { 
if ( k != 0 ) 
fprintf ( stderr , ", " ) ; 
fprintf ( stderr , "%ld" , cnet . net_lower [ k ] ) ; } 

fprintf ( stderr , "]" ) ; } 

fprintf ( stderr , "\n" ) ; } 


dmPutDesignData ( dsp_net , CIR_NET ) ; } 



 snetOld = ( struct simpleNet * ) ( snet ) ; 

 snet = ( struct simpleNet * ) ( snet -> next ) ; { _that = ( int * ) 

 snetOld ; free ( _that ) ; } } 


 snetQueue = ( struct simpleNet * ) ( 0 ) ; 
intNetCnt = 0 ; 

while ( ! _17queue_empty ( ( struct queue * ) q ) ) { 
 pnet = ( struct netelem * ) _13queue_get ( ( struct queue * ) q ) ; 
if ( pnet -> nmem ) { _that = ( int * ) 
 pnet -> nmem ; free ( _that ) ; } { _that = ( int * ) 
 pnet ; _2netelem_delete ( ( struct netelem * ) _that ) ; free ( _that ) ; } } { _that = ( int * ) 

 q ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } } /* outSimple */ 


int cis [ 10 ] ; 

int fillArrNet ( pcnet , nmem , prefcnet ) struct cir_net * pcnet ; struct netMember * nmem ; struct cir_net * prefcnet ; 



{ int * _that ; 
int i ; 
int offs ; 
int i_offs ; struct netMember 
* help ; 

if ( nmem -> inst ) { 

if ( pcnet -> inst_dim > 0 ) { { _that = ( int * ) 
 pcnet -> inst_lower ; free ( _that ) ; } { _that = ( int * ) 
 pcnet -> inst_upper ; free ( _that ) ; } } 


 help = ( struct netMember * ) ( nmem - nmem -> inst -> inst_struct -> nmem ) ; 
 i_offs = ( int ) help ; 
 i_offs = i_offs / nmem -> inst -> inst_struct -> termCnt ; 


 pcnet -> inst_dim = findCi ( nmem -> inst -> inst_struct -> inst_construct , i_offs ) ; 

if ( pcnet -> inst_dim > 0 ) { 
pcnet -> inst_lower = ( long * ) calloc ( ( unsigned ) ( pcnet -> inst_dim ) , sizeof ( long ) ) ; 
pcnet -> inst_upper = ( long * ) calloc ( ( unsigned ) ( pcnet -> inst_dim ) , sizeof ( long ) ) ; } 


for ( i = 0 ; i < pcnet -> inst_dim ; i ++ ) { 
pcnet -> inst_lower [ i ] = cis [ i ] ; 
pcnet -> inst_upper [ i ] = cis [ i ] ; } } 



if ( pcnet -> net_dim > 0 ) { { _that = ( int * ) 
 pcnet -> net_lower ; free ( _that ) ; } { _that = ( int * ) 
 pcnet -> net_upper ; free ( _that ) ; } } 


if ( nmem -> inst ) { 


 help = ( struct netMember * ) ( nmem - ( nmem -> inst -> inst_struct -> nmem + ( i_offs * nmem -> inst -> inst_struct -> termCnt ) + ( int ) ( nmem -> net -> nmem ) ) ) ; 
 offs = ( int ) help ; } 

else { 
 help = ( struct netMember * ) ( nmem - nmem -> net -> nmem ) ; 
 offs = ( int ) help ; } 


 pcnet -> net_dim = findCi ( nmem -> net -> xs , offs ) ; 

if ( pcnet -> net_dim > 0 ) { 
pcnet -> net_lower = ( long * ) calloc ( ( unsigned ) ( pcnet -> net_dim ) , sizeof ( long ) ) ; 
pcnet -> net_upper = ( long * ) calloc ( ( unsigned ) ( pcnet -> net_dim ) , sizeof ( long ) ) ; } 


for ( i = 0 ; i < pcnet -> net_dim ; i ++ ) { 
pcnet -> net_lower [ i ] = cis [ i ] ; 
pcnet -> net_upper [ i ] = cis [ i ] ; } 


if ( prefcnet ) { 
if ( pcnet -> ref_dim > 0 ) { { _that = ( int * ) 
 pcnet -> ref_lower ; free ( _that ) ; } { _that = ( int * ) 
 pcnet -> ref_upper ; free ( _that ) ; } } 


pcnet -> ref_dim = prefcnet -> net_dim ; 

if ( pcnet -> ref_dim > 0 ) { 
pcnet -> ref_lower = ( long * ) calloc ( ( unsigned ) ( pcnet -> ref_dim ) , sizeof ( long ) ) ; 
pcnet -> ref_upper = ( long * ) calloc ( ( unsigned ) ( pcnet -> ref_dim ) , sizeof ( long ) ) ; } 


for ( i = 0 ; i < pcnet -> ref_dim ; i ++ ) { 
pcnet -> ref_lower [ i ] = prefcnet -> net_lower [ i ] ; 
pcnet -> ref_upper [ i ] = prefcnet -> net_upper [ i ] ; } } } /* fillArrNet */ 
#line 581 "simple.cls"
int findCi ( xs , offset ) struct stack * xs ; int offset ; 


{ int * _that ; int _result ; 
int i ; 
int dim ; 
int v ; 
int weight ; 
int lb , rb ; 
char * * pxs ; 

int w [ 10 ] ; 

if ( xs ) { 
 dim = i = _21stack_limit ( ( struct stack * ) xs ) - _20stack_base ( ( struct stack * ) xs ) ; 
 pxs = _21stack_limit ( ( struct stack * ) xs ) ; 

i -- ; 
pxs -- ; 
weight = 1 ; 
for ( ; i >= 0 ; i -- ) { 
 rb = ( ( struct xelem * ) * pxs ) -> right_bound ; 
 lb = ( ( struct xelem * ) * pxs ) -> left_bound ; 
w [ i ] = weight ; 
if ( rb > lb ) { 
weight = weight * ( rb - lb + 1 ) ; } 

else { 
weight = weight * ( lb - rb + 1 ) ; } 

if ( i > 0 ) pxs -- ; } 


i = 0 ; 
for ( ; i < dim ; i ++ ) { 
v = offset / w [ i ] ; 
offset = offset % w [ i ] ; 
 rb = ( ( struct xelem * ) * pxs ) -> right_bound ; 
 lb = ( ( struct xelem * ) * pxs ) -> left_bound ; 
if ( lb < rb ) 
cis [ i ] = lb + v ; 
else 
cis [ i ] = rb + v ; 
pxs ++ ; } } 


else 
dim = 0 ; { _result = 

 ( dim ) ; goto _return ; } _return : return _result ; } /* findCi */ 
