%{
/* SccsId = "@(#)spilex.l 4.5 (TU-Delft) 12/09/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 14-May-1992
Modified by       : 
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "spipar.h"

extern int behind_header;  /* used for setting initial condition:
			      only if behind_header = 1, a name starting
			      with a 'r' should be recognized as a resistor */
#ifdef FLEX_SCANNER
int yylineno = 1;
#endif

%}

D	[0-9]
E	[DEde][-+]?{D}+

%START NL

%%
[*;]			{ int thechar;
			    while((thechar = input()) != '\n') {
				if(thechar == EOF) return(0);
			    }
			    unput('\n');
			}
"#"[^\n]*\n             { void parseLineStmt ();
                          if (behind_header)
			      BEGIN NL;
			  parseLineStmt ((char *) yytext);
		        }
".subckt"		{ BEGIN 0; return(SUBCKT); }
".SUBCKT"		{ BEGIN 0; return(SUBCKT); }
".ends"			{ BEGIN 0; return(ENDS); }
".ENDS"			{ BEGIN 0; return(ENDS); }
".end"			{ BEGIN 0; return(END); }
".END"			{ BEGIN 0; return(END); }
".connect"		{ BEGIN 0; return(CNET); }
".CONNECT"		{ BEGIN 0; return(CNET); }
"."[a-zA-Z0-9_]*	{ BEGIN 0; return(OTHER_CARD_BEGIN); }
"."			{ BEGIN 0; return(PERIOD); }
"="			{ BEGIN 0; return(ASSIGN)  ; }
"("			{ BEGIN 0; return(LPS)     ; }
")"			{ BEGIN 0; return(RPS)     ; }
<NL>vnet[a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(VNET); }
<NL>VNET[a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(VNET); }
<NL>rnet[a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(RNET); }
<NL>RNET[a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(RNET); }
<NL>[mM][a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(TOR_INST); }
<NL>[xXqQjJ][a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(NETW_INST); }
<NL>[rR][a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(RES_INST); }
<NL>[cC][a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(CAP_INST); }
[wW]			{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(T_WIDTH); }
[lL]			{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(T_LENGTH); }
[a-zA-Z][a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(IDENTIFIER); }
"-"?{D}+		{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(INTEGER); }
"-"?{D}+("."{D}+)?({E})?([a-zA-Z_]*)? 
			{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(FLOAT); }
"\n+"                   { ; }  /* this is a line (card) continuation. */
[\t ]+			{ BEGIN 0; }
\n			{ if (behind_header) BEGIN NL; return(NEWLINE); }
[^=^.^(^)^ ^\n^\t^+^-]+	{ BEGIN 0; return(OTHER); }
%%

int Input ()
{
    return (input ());
}
