static char *SccsId = "@(#)addfunte.c 4.3 (TU-Delft) 07/27/92";
/**********************************************************

Name/Version      : func_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : GOULD

Author(s)         : O. Hol
Creation date     : 05-Nov-1987
Modified by       : S. de Graaf
Modification date : 25-Apr-1988
Modified by       : P.E. Menchen
Modification date : 24-Sep-1991


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1991, All rights reserved
**********************************************************/
#include "func_parse.h"

/* Function addfun_term
** creates for the function block the files 'fterm' and
** 'fstate' in the circuit database and fills the files
** with data about the terminals and state variables.
*/
void    addfun_term (list)
FTERM * list;
{
    register FTERM * sc_ptr;
    char type;
    long    low[2];
    long    ind[2];

#if NCF_RELEASE >= 400
    if (cirflag)
	fdes = dmOpenStream (key, "fterm", "w");
    else
	fdes = dmOpenStream (key, "term", "w");
#else
    fdes = dmOpenStream (key, "fterm", "w");
#endif

    low[0] = 0;
    low[1] = 0;
    for (sc_ptr = list; sc_ptr != NULL && (sc_ptr -> type != StateChar &&
		sc_ptr -> type != StateInt && sc_ptr -> type != StateFloat
		&& sc_ptr -> type != StateDouble);
	    sc_ptr = sc_ptr -> next) {
	ind[0] = sc_ptr -> ind[0];
	ind[1] = sc_ptr -> ind[1];
	strcpy (cterm.term_name, sc_ptr -> name);
	if (ind[0] > 0) {
	    if (ind[1] > 0)
		cterm.term_dim = 2;
	    else
		cterm.term_dim = 1;
	}
	else
	    cterm.term_dim = 0;

	ind[0]--;
	ind[1]--;
	cterm.term_lower = low;
	cterm.term_upper = ind;

	switch (sc_ptr -> type) {
	    case OutpTerm:
		cterm.term_attribute = "ftt=0";
		break;
	    case InoTerm:
		cterm.term_attribute = "ftt=3";
		break;
	    case InpTerm:
		cterm.term_attribute = "ftt=1";
		break;
	    case InrTerm:
		cterm.term_attribute = "ftt=2";
		break;
	}

	dmPutDesignData (fdes, CIR_TERM);
	if (dummy)
	    dmPutDesignData (ddes, CIR_TERM);
    }

    dmCloseStream (fdes, COMPLETE);

    if (sc_ptr != NULL) {
	fdes = dmOpenStream (key, "fstate", "w");

	for (; sc_ptr != NULL; sc_ptr = sc_ptr -> next) {
	    ind[0] = sc_ptr -> ind[0];
	    ind[1] = sc_ptr -> ind[1];
	    switch (sc_ptr -> type) {
		case StateChar:
		    type =  'c';
		    break;
		case StateInt:
		    type =  'i';
		    break;
		case StateFloat:
		    type =  'f';
		    break;
		case StateDouble:
		    type =  'd';
		    break;
	    }
	    fprintf (fdes -> dmfp, "%s %d %d %c\n",
		sc_ptr -> name, ind[0], ind[1], type);
	}

	dmCloseStream (fdes, COMPLETE);
    }
}
