/* SccsId = "@(#)incl.h 4.4 (TU-Delft) 12/17/90" */
/**********************************************************

Name/Version      : cgi/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/500

Author(s)         : R. Paulussen
Creation date     : 18-Jan-1988
Modified by       : S. de Graaf
Modification date : 18-Mar-1988
Modification date : 20-May-1988
Modification date : 19-Sep-1988
Modification date : 25-Jun-1990 (4.02)
Modification date : 22-Nov-1990 (4.04)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988, All rights reserved
***********************************************************
MADE BY:
	Delft University of Technology
	Department of Submicron Technology
	Lorentzweg 1
	DELFT
	The Netherlands
**********************************************************/
#include "defs.h"
#include "stdio.h"
#include "signal.h"
#include "sys/types.h"
#include "sys/stat.h"
#include "dmincl.h"

#define MAXPATH   50           /* max # of chars in a pathname */
#define NOINTS    (2*MAX_COOR) /* max # of ints  of a boundary */

#define ALLOC(ptr,type) {\
if(!(ptr=(struct type *)malloc(sizeof(struct type))))\
pr_exit (A, 17, 0); }

#define FREE(ptr) free((char *)(ptr))

#define Min(a,b) ((a)<(b)?(a):(b))
#define Max(a,b) ((a)>(b)?(a):(b))

#define NEXT_RECORD next_rec ()

struct mod_bbox { /* cell bounding box co-ordinates */
    long   xl, xr, yb, yt;
};

struct name_tree {
    char              name[DM_MAXNAME+1]; /* name of cell */
    IMPCELL          *impcell;  /* imported cell (if set) */
    struct mod_bbox  *bbox;               /* bbox struct  */
    int               status;             /* status cell  */
    struct name_tree *rchild;             /* tree childs  */
    struct name_tree *lchild;
};

struct stat stat_buf; /* file status info */

#ifdef SYSV
#define rindex strrchr
#endif SYSV

double  atof ();		/* system routine */
char   *malloc ();		/* system routine */
char   *recordName ();		/* utility routine */
char   *rindex ();		/* system routine */
char   *strcpy ();		/* system routine */
char   *strsave ();		/* utility routine */

int	lay_code;	/* layer code (of process table) */
int     ini_bbbox = 0;	/* bounding box flags, set when a ms statement */
int     ini_mcbbox = 0;	/* is encountered, reset when the
			   corresponding bounding box gets a value */

char    ms_name[DM_MAXNAME+1] = "??";/* name of current cell def. */
char    mc_name[DM_MAXNAME+1];	/* name of cell called */
char    instance[DM_MAXNAME+1];	/* name of cell inst. */

/* Binary sorted name trees */

struct name_tree   *tree_ptr = NULL;
struct name_tree   *mod_tree = NULL;
                   /* tree containing names of cells
		      defined in the database */

DM_PROJECT  *dmproject = NULL;          /* ptr to project      */
DM_PROCDATA *process;                   /* ptr to process info */
DM_CELL     *mod_key = NULL;            /* ptr to cell         */
DM_STREAM   *fp_info, *fp_mc,
            *fp_box, *fp_term, *fp_nor;

/* Element Parameters: */

double  tmp_d;			/* temporary usable double */
int	tmp_i;			/* temporary usable integer */
int     int_val[NOINTS];	/* int  number buffer */
int     dx, nx, dy, ny;         /* repetition  */
long    bbnd_xl, bbnd_xr;       /* box bounding box */
long    bbnd_yb, bbnd_yt;
long    mcbb_xl, mcbb_xr;       /* cell reference bbox */
long    mcbb_yb, mcbb_yt;

