/* SccsId = "@(#)dmglobal.h 3.11 (TU-Delft) 04/28/93" */
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 21-Jan-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988 , All rights reserved
**********************************************************/

#ifndef __DMGLOBAL_H
#define __DMGLOBAL_H

char   *dmviews[] = {
	LAYOUT,
	CIRCUIT,
	FLOORPLAN
};
/*
** See dmincl.h: DM_NOVIEWS == sizeof (dmviews) / sizeof (char *)
*/

/*
** DDM environment
*/
char   *dmpls = NULL;
char   *dmhome = NULL;
char   *dmcur_project = NULL;
char   *dmcur_view = NULL;
char   *dmcur_cell = NULL;
char   *dmprompt = NULL;
char   *dmtoolbox = NULL;

/*
** DDM error handling
*/
int     dmerrno = 0;

char   *dmerrlist[] =
{
    "DDM error number 0",
    "error in system call",
    "DDM internal error",
    "bad arguments to DDM function call",
    "mode is invalid for key",
    "bad project",
    "bad view",
    "cell does not exist",
    "bad key",
    "cell is already checked out",
    "cannot open primary file for writing",
    "illegal recursion",
    "cell already exists",
    "cannot open technology file",
    "dmPutDesignData write error",
    "dmGetDesignData read error",
    "bad format",
    "unknown process id",
    "cannot access process data",
    "no more core",
    "process data read error",
    "bad current view",
    "bad name",
    "view does not exist",
    "view already exists",
    "project is locked",
    "cannot open file",
    "bad DDM environment",
    "no celllist present",
    "already initialized",
    "no project list present",
    "no imported celllist present",
#ifdef MSDOS
    "cannot open file dmrc.dot",
#else
    "cannot open file .dmrc",
#endif
    "bad release",
    "not yet initialized",
    "design manager error",
    "design manager rejects request",
    "cell is not a root",
    "no father cell",
};

int     dmnerr = sizeof (dmerrlist) / sizeof (char *);

#endif /* __DMGLOBAL_H */

