static char *SccsId = "@(#)dmmeta.c 3.8 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 17-May-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988, All rights reserved
**********************************************************/
#include <stdio.h>
#include <dmstd.h>
#  ifdef __STDC__
#include <stdarg.h>
#  else /* not __STDC__ */
#include <varargs.h>
#  endif /* else not __STDC__ */

typedef     long (*FUN) ();
int     _dmAddImportedCell ();
int     _dmExistCell ();
int     _dmExistView ();
int     _dmAddCellEquivalence ();
int     _dmCellIsRoot ();

static  FUN dmreqgetfunc[] = {
    ((FUN) _dmImportedCelllist),
    ((FUN) _dmCellEquivalence),
    ((FUN) _dmGetProcess),
    ((FUN) _dmCelllist),
    ((FUN) _dmProjectlist),
    ((FUN) _dmExistCell),
    ((FUN) _dmExistView),
    ((FUN) _dmGetProcPath),
    ((FUN) _dmCellIsRoot),
    ((FUN) _dmFatherCell),
};

static  FUN dmreqputfunc[] = {
    ((FUN) _dmAddImportedCell),
    ((FUN) _dmAddCellEquivalence),
};

#  ifdef __STDC__
char   *dmGetMetaDesignData (int reqid, DM_PROJECT * projectid, ...)
# else				/* not __STDC__ */
char   *dmGetMetaDesignData (reqid, projectid, va_alist)
int     reqid;
DM_PROJECT * projectid;
va_dcl
#  endif			/* else not __STDC__ */
{
    char   *cell,
           *view,
           *view2,
           *file_name;
    va_list ap;
#  ifdef __STDC__
    va_start (ap, projectid);
#  else /* not __STDC__ */
    va_start (ap);
#  endif /* else not __STDC__ */
    switch (reqid) {
	case IMPORTEDCELLLIST: 
	    view = va_arg (ap, char *);
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid, view));
	case CELLEQUIVALENCE: 
	    cell = va_arg (ap, char *);
	    view = va_arg (ap, char *);
	    view2 = va_arg (ap, char *);
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid,
			cell, view, view2));
	case PROCESS: 
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid));
	case CELLLIST: 
	    view = va_arg (ap, char *);
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid, view));
	case PROJECTLIST: 
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid));
	case EXISTCELL: 
	    cell = va_arg (ap, char *);
	    view = va_arg (ap, char *);
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid, cell, view));
	case EXISTVIEW: 
	    view = va_arg (ap, char *);
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid, view));
	case PROCPATH: 
	    file_name = va_arg (ap, char *);
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid, file_name));
	case CELLISROOT: 
	    cell = va_arg (ap, char *);
	    view = va_arg (ap, char *);
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid, cell, view));
	case FATHERCELL: 
	    cell = va_arg (ap, char *);
	    view = va_arg (ap, char *);
	    return ((char *) (*dmreqgetfunc[reqid]) (projectid, cell, view));
    }
    return (0);
}

#  ifdef __STDC__
char   *dmPutMetaDesignData (int reqid, DM_PROJECT * projectid, ...)
# else				/* not __STDC__ */
char   *dmPutMetaDesignData (reqid, projectid, va_alist)
int     reqid;
DM_PROJECT * projectid;
va_dcl
#  endif			/* else not __STDC__ */
{
    char   *cell,
           *cell2,
           *view,
           *view2,
           *alias,
           *path;
    va_list ap;
#  ifdef __STDC__
    va_start (ap, projectid);
#  else /* not __STDC__ */
    va_start (ap);
#  endif /* else not __STDC__ */
    switch (reqid) {
	case IMPORTEDCELLLIST: 
	    cell = va_arg (ap, char *);
	    alias = va_arg (ap, char *);
	    view = va_arg (ap, char *);
	    path = va_arg (ap, char *);
	    return ((char *) (*dmreqputfunc[reqid]) (projectid,
			cell, alias, view, path));
	case CELLEQUIVALENCE: 
	    cell = va_arg (ap, char *);
	    view = va_arg (ap, char *);
	    cell2 = va_arg (ap, char *);
	    view2 = va_arg (ap, char *);
	    return ((char *) (*dmreqputfunc[reqid]) (projectid,
			cell, view, cell2, view2));
    }
    return (0);
}
