static char *SccsId = "@(#)dmtname.c 3.9 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 30-Mar-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/
#include "dmstd.h"

dmTestname (name)
char   *name;
{
    int     i;

    if (name == NULL) {
	dmerrno = DME_BADNAME;
	dmError ("NULL");
	return (-1);
    }

    if (!isalpha (name[0])) {
	dmerrno = DME_BADNAME;
	dmError (name);
	return (-1);
    }

    for (i = 1; i < DM_MAXNAME && name[i] != '\0'; i++) {
	if (!(isalpha (name[i]) || isdigit (name[i]) ||
		    name[i] == '_')) {
	    dmerrno = DME_BADNAME;
	    dmError (name);
	    return (-1);
	}
    }

    if (i >= DM_MAXNAME) {
	if (name[DM_MAXNAME] != '\0') {
	    name[DM_MAXNAME] = '\0';
	    return (1);
	}
    }
    return (0);
}
