static char *SccsId = "@(#)dmunlink.c 3.5 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/
#include "dmstd.h"

/*
** This function tries to unlink the (2ndary) file
** of the cell with the specified key.
** -1 is returned by error condition.
*/

dmUnlink (key, file)
DM_CELL * key;
char   *file;
{
    char    path[MAXLINE];

#ifdef DM_DEBUG
    IFDEBUG
	fprintf (stderr, "keyno: %d, file: %s\n",
	    key -> keyno, file);
#endif /* DM_DEBUG */

    if (_dmCh_key (key) != 0) {
	dmError2 ("dmUnlink: file", file);
	return (-1);
    }

    _dmSprintf (path, "%s/%s/%s/%s", key -> dmproject -> dmpath,
		    key -> view, key -> cell, file);

#ifdef DM_DEBUG
    IFDEBUG
	fprintf (stderr, "path: %s\n", path);
#endif /* DM_DEBUG */

    return (unlink (path));
}
