static char *SccsId = "@(#)BSTOI.c 4.2 (TU-Delft) 03/10/92";
/**********************************************************

Name/Version      : libfunc/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : GOULD

Author(s)         : O. Hol
Creation date     : 18-Feb-1988
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988 , All rights reserved
**********************************************************/
#include <stdio.h>
#ifdef apollo
#include "/sys5/usr/include/values.h" /* sorry, hard */
#else
# ifdef SYSV
# include 	<values.h>
# else /* Assume 8 bits per byte and highest bit is sign bit */
# define MAXINT  (~(1<<(8*(int)sizeof(int))-1))
# endif
#endif


/* BSTOI()  : converts a bit string into an integer using the radix-2   */
/*          : representation                                            */

int BSTOI (s)
char  s[];
{
    int res = 0;
    int i;
    int w;

    if ( strlen(s) > sizeof(int)*8 ){
	fprintf( stderr,
		"WARNING: BSTOI :bit string contains more then %d bits\n",
	        sizeof(int)*8 );
	return(MAXINT);
    }
    for (i = 0 , w = 1 << ( strlen(s) -1 ) ; i < strlen(s) ; i++, w /= 2) {
        if (s[i] == 'I')
            res += w;
	else if ( s[i] == 'X' )
	    return(MAXINT);
    }

    return (res);
}
