/* SccsId = "@(#)define.h 4.4 (TU-Delft) 04/20/93" */
/**********************************************************

Name/Version      : makebox/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 22-Apr-1986
Modified by       : S. de Graaf
Modification date : 01-Sep-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "stdio.h"
#include "signal.h"
#include "sys/types.h"
#include "sys/stat.h"
#include "dmincl.h"

#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif

#define P_E fprintf(stderr,

struct mc_elmt { /* mc-tree node structure */
    struct clist *parent;	/* link to parent cell node */
    char   name[DM_MAXNAME+1];	/* cell name or alias */
    char   inst_name[DM_MAXNAME+1]; /* instance name */
    long   mtx[6];		/* transf. matrix */
    long   dx, nx;		/* x-copies */
    long   dy, ny;		/* y-copies */
    struct mc_elmt *mc_next;	/* link to next element */
};

struct clist { /* cell-list element structure */
    DM_CELL        *ckey;	/* cell access key */
    int            hier;        /* 0: flatten; 
				   1: use as an instance
				   2: flatten + use as an instance */
    struct mc_elmt *mc_p;	/* link to mc-node */
    struct mc_elmt *mc_p_last;	/* link to last mc-node */
    struct clist   *cl_next;	/* link to next element */
    struct clist   *ht_next;	/* link to next hashtable element */
};

struct tmtx { /* transf. matrix element structure */
    char  *name;		/* cell name or alias */
    long   mtx[6];		/* transf. matrix */
    struct tmtx *tm_next;	/* link to next element */
};

#define ALLOCPTR(ptr,name) {\
if(!(ptr=(struct name *)malloc(sizeof(struct name))))\
errexit(6,"");}

#define ALLOCARR(ptr,elmts,name) {\
if(!(ptr=(name *)malloc(elmts * sizeof(name))))\
errexit(6,"");}

#define FREE(ptr) free((char *)(ptr))

/* char   *malloc ();	/* system routine */
/* char   *strcpy ();	/* system routine */

# if NCF_RELEASE >= 400
# define dmpath TMPath
# endif

# if NCF_RELEASE < 400
# include "dmdef.h"
# define DM_MAXPATHLEN MAXLINE
# endif
