/* SccsId = "@(#)incl.h 4.1 (TU-Delft) 05/24/90" */
/**********************************************************

Name/Version      : makevln/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 29-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "stdio.h"
#include "signal.h"
#include "dmincl.h"

/* General definitions: */
#define MAX_INTEGER     2000000000
#define MIN_INTEGER    -2000000000
#define TRUE		1
#define FALSE		0

/* Edge Type Definitions: */
# define START	 	001
# define STOP		002
# define ChgCT	 	004
# define StartOl	010
# define StopOl		020

/* Connect Type Definitions: */
#define NULL_CONN       0
#define DOWN_CONN	1
#define UP_CONN		2
#define TWO_CONN	(DOWN_CONN + UP_CONN)

/* Change Edge Type Definitions: */
#define OfCt		01
#define OfOl		02
#define ToZero		04

/* Data Structure Definitions: */
struct sr_field {
   long yb, yt;
   long duration;
   long ol_dur;
   long checktype;
   struct group_tree *group;
   struct {
      unsigned start: 1;
      unsigned overlap: 1;
      unsigned ol_area: 1;
      unsigned incident: 1;
      unsigned ct_zero: 1;
   } flag;
   struct sr_field *prev, *next;
};

struct group_tree {
    int    tree_count;
    struct group_tree  *parent;
    struct group_tree  *next;
};

struct event_rec {
    long    xl, xr, yb, yt;
    long    attr_no;
};

struct S_vln {
    long    x, yb, yt;
    char    occ, con;
    struct  group_tree *grp;
    long    cht;
};

struct S_teq {
    long    tnr;
    struct  group_tree *grp;
};

char   *calloc ();		/* system routine */
struct group_tree *fdgrp_ptr();

/* Memory Allocation/Release Macro's: */

#define ALLOCPTR(ptr,name) {if((\
ptr=(struct name *)calloc(1,sizeof(struct name))\
)==NULL)errexit(3,"");}

#define ALLOCARR(ptr,elmts,name) {if((\
ptr=(name *)calloc((unsigned)(elmts),sizeof(name))\
)==NULL)errexit(3,"");}

#define FREE(ptr) free((char *)ptr)

/* General Purpose Macro's: */

#define Min(a,b) ((a)<(b)?(a):(b))
#define Max(a,b) ((a)>(b)?(a):(b))

/* Connect Type Macro: */

#define CONNECTED(c1_sr,c2_sr) \
(c1_sr != h_sr && c2_sr != h_sr && c1_sr->yt == c2_sr->yb)

#define CONN_SGRP(c1_sr,c2_sr) \
(CONNECTED(c1_sr,c2_sr) && fdgrp_ptr(c1_sr->group) == fdgrp_ptr(c2_sr->group))
