static char *SccsId = "@(#)main.c 4.3 (TU-Delft) 01/23/91";
/**********************************************************

Name/Version      : NBOOL/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)	  : T.G.R. van Leuken, J.T. Fokkema
Creation date	  : 15-Jun-1982
Modified by       : J. Liedorp
Modification date : 15-Jan-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
#include "nbool.h"

#define USAGE fprintf(stderr,use_msg,argv0);exit(1)
DM_PROJECT * dmproject;

char   *argv0 = "nbool";	/* program name */
char   *use_msg =		/* command line */
        "\nUsage: %s [-f] [-n|-c] [cell_name]\n\n";


main (argc, argv)
int     argc;
char   *argv[];
{
    int     sig_handler ();	/* signal handler */
    char    modelname[DM_MAXNAME + 1];
    int     iarg;		/* argument number */
    char   *p;
    int     file_flag;
    int     cell_name_flag;
    char    excl_option;

    excl_option = '\0';
    pid = getpid ();
    chk_flag = CHK_HRCHY;
    file_flag = OFF;
    cell_name_flag = OFF;

    for (iarg = 1; iarg < argc && argv[iarg][0] == '-'; ++iarg) {
	p = &argv[iarg][1];
	while (*p != '\0') {
	    switch (*p++) {
		case 'c': 
		    if (excl_option == 'n') {
			fprintf (stderr, "\nthe -c and -n options are mutually exclusive");
			USAGE;
		    }
		    chk_flag = CHK_HRCHY;
		    excl_option = 'c';
		    break;
		case 'f': 
		    file_flag = ON;
		    break;
		case 'n': 
		    if (excl_option == 'c') {
			fprintf (stderr, "\nthe -c and -n options are mutually exclusive");
			USAGE;
		    }
		    chk_flag = NO_CHK_HRCHY;
		    excl_option = 'n';
		    break;
		default: 
		    fprintf (stderr, "\nunknown option: %.1s", --p);
		    USAGE;
	    }
	}
    }
    if (iarg == argc - 1)
	cell_name_flag = ON;
    if (iarg < (argc - 1)) {
	if (argv[argc - 1][0] == '-') {
	    fprintf (stderr, "\ncell_name must be the last argument");
	    USAGE;
	}
	else {
	    fprintf (stderr, "\ntoo many arguments");
	    USAGE;
	}
    }
    signal (SIGHUP, SIG_IGN);	/* ignore hangup signal */
    signal (SIGQUIT, SIG_IGN);
    signal (SIGTERM, sig_handler);

    if (signal (SIGINT, SIG_IGN) != SIG_IGN)
	signal (SIGINT, sig_handler);

    dmInit (argv0);
    if ((dmproject = dmOpenProject (DEFAULT_PROJECT, DEFAULT_MODE)) == NULL)
	exit (1);

    process = (DM_PROCDATA *) dmGetMetaDesignData (PROCESS, dmproject);

    mask_terms = 0;

    if (cell_name_flag == OFF) {

    /* perform nbool for each model from the EXPDATA file */

	sprintf (filename, "%s/%s", dmproject -> dmpath, EXPDATA);
	OPEN (pexp, filename, "r");
	while (fscanf (pexp, "%s", modelname) != EOF) {
	    bool_cell (modelname, file_flag);
	}
    }
    else {
	bool_cell (argv[argc - 1], file_flag);
    }
    die (0);
}

bool_cell (modelname, file_flag)
char   *modelname;
int     file_flag;
{

    register struct form   *f_pntr;/* ptr to form struct */
    DM_STREAM *drcstream;

    mod_key = dmCheckOut (dmproject, modelname,
	    WORKING, DONTCARE, LAYOUT, ATTACH);
#ifdef DRCERRORSTREAM
    drcstream = dmOpenStream (mod_key, "nbool", "w");
    pout = drcstream->dmfp;
#else
    pout = stdout;
#endif
    fprintf (pout, "\ncell: %s\n\n", modelname);
    mk_formstruct (file_flag);
    main_bool ();
    free_state_ruler ();
    f_pntr = fp_head;
    while (f_pntr) {
	add_grpnbr (f_pntr -> f_nbr);
	f_pntr = f_pntr -> next;
    }
    free_formstruct ();
#ifdef DRCERRORSTREAM
    dmCloseStream (drcstream, COMPLETE);
#endif
    dmCheckIn (mod_key, COMPLETE);
}


sig_handler (sig)		/* signal handler */
int     sig;
{
    signal (sig, SIG_IGN);	/* ignore signal */
    fprintf (stderr,
	    "%s: interrupted due to signal: %d\n", argv0, sig);
    die (1);
}

dmError (s)
char   *s;
{
    fprintf (stderr, "%s: ", argv0);
    dmPerror (s);
    fprintf (stderr,
	    "%s: error in dbm interface function\n", argv0);
    die (1);
}

die (status)
int     status;
{
    register struct form   *f_pntr;/* ptr to form struct */

    if (status) {
	f_pntr = fp_head;
	while (f_pntr) {
	    sprintf (fr_name, TEMP_ONE, f_pntr -> f_nbr, pid);
	    unlink (fr_name);
	    f_pntr = f_pntr -> next;
	}
	unlink (fi_name);
	fprintf (stderr, "%s: -- program aborted --\n", argv0);
    }
    if (dmproject)
	dmCloseProject (dmproject, COMPLETE);
    dmQuit ();
    exit (status);
}
