static char *SccsId = "@(#)main_bool.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : NBOOL/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 31-Jan-1985
Modified by       : S. de Graaf
Modification date : 09-Dec-1985


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
**********************************************************/
#include "nbool.h"

main_bool ()
{
/*   Initialize the nbool data structures.		 */
/*   Make the stateruler_profiles by repeatedly calling	 */
/*   select_edge and insert_edge; extract each		 */
/*   profile by calling extract_profile.		 */

    int     next_edge;		/* status of edge heap	 */
    struct sr_field *r_sr;	/* ptr to first fld of rsr */
    int     sr_pos;		/* state_ruler position	 */
    int     edge_pos,		/* x_value of the edge	 */
            yb,			/* bottom of the edge	 */
            yt,			/* top of the edge	 */
            chk_type;		/* check_type of the edge */
    unsigned    mask;		/* edge mask_code	 */
    char    edge_type;		/* type of the edge	 */
    struct form *frm_pntr;	/* pointer to the forms	 */

    /* initialize state ruler */
    h_sr = &head_sr;
    h_sr -> chk_type = INITIAL;
    h_sr -> yt = MAXINT;
    h_sr -> yb = -MAXINT;
    h_sr -> next = h_sr -> prev = &head_sr;

    next_edge = select_edge (&edge_pos, &yb, &yt, &edge_type,
	    &chk_type, &mask);
    sr_pos = edge_pos;
    while (next_edge) {
	r_sr = h_sr;
	do
	    insert_edge (&r_sr, yb, yt, edge_type, chk_type, mask);
	while ((next_edge = select_edge (&edge_pos, &yb, &yt, &edge_type,
			&chk_type, &mask)) != NULL &&
		edge_pos == sr_pos);

	if (chk_flag == CHK_HRCHY)
	    check_hierarchy (sr_pos);
	extr_profile (sr_pos);
	update_sr ();
	sr_pos = edge_pos;
    }

    /* now the last remaining edges are put on the files */

    frm_pntr = fp_head;
    while (frm_pntr) {
	if (frm_pntr -> curr_place != -1) {
	    write_buf (frm_pntr, frm_pntr -> curr_place);
	}
	frm_pntr = frm_pntr -> next;
    }
}
