/* SccsId = "@(#)type.h 4.5 (TU-Delft) 05/17/93" */
/**********************************************************

Name/Version      : simeye/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 29-May-1990
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1990 , All rights reserved
**********************************************************/
/* the following definitions are for resfile */

#define MAXLEN 15   /* for resfile */
#define MAXDIM  4

typedef struct path_spec {
    char    name[MAXLEN + 1];
    int     xarray[MAXDIM + 1][2];
    struct path_spec   *next;
    struct path_spec   *also;
}                           PATH_SPEC;

typedef struct res_path {
    PATH_SPEC * path;
    int     totnum;
    struct res_path *next;
}                       RES_PATH;

typedef struct res_file {
    char    name[MAXLEN + 1];
            RES_PATH * signals;
    float   scaling;
    int     sig_cnt;
    long    offset;
            FILE * fp;
    struct res_file *next;
}                       RES_FILE;

typedef struct string_ref {
    char   *str;
    struct string_ref  *next;
}                           STRING_REF;

/* the following definitions are for cmd_y.y */

#define Free_state           00
#define L_state              01
#define X_state              02
#define H_state              03

typedef struct signalelement
{
    int val;
    int len;
    struct signalelement *sibling;
    struct signalelement *child;
} SIGNALELEMENT;

typedef struct node {
    char *name;
    short no_edit;
    struct signalelement *expr;
    struct node *next;
};

/* the above definitions are for resfile and cmd_y.y */

/* the following definitions are the general types used */

typedef struct sig_value {
    long time;
    int value;
    struct sig_value *next;
    struct sig_value *prev;
};

typedef struct signal {
    char *name;
    int i;
    short no_edit;
    short endless;
    short stringValue;
    struct signalelement *expr;
    struct signal *next;
    struct signal *prev;
    struct signal *orig_next;
    struct signal *layover;
    struct sig_value *begin_value;
    struct sig_value *end_value;
    struct sig_value *last_value;
    struct sig_value *begin_value_L;
    struct sig_value *end_value_L;
    struct sig_value *last_value_L;
    struct sig_value *begin_value_U;
    struct sig_value *end_value_U;
    struct sig_value *last_value_U;
};

typedef int Grid;
