static char *SccsId = "@(#)nodePoint.c 4.4 (TU-Delft) 04/20/93";
/**********************************************************

Name/Version      : space/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#ifdef DRIVER
#define DISPLAY
#endif

#include <math.h>
#include <stdio.h>
#include "include/config.h"
#include "include/type.h"
#include "aux/aux.h"
#include "extract/define.h"
#include "extract/extern.h"

/*
 * Allignment is a tricky issue;
 * This routine works on all hardware we have tried
 * thanks to the fact that all items in the allocated structs
 * have a size that is a multiple of 4 and can be allocated 
 * on a 4-byte boundary.
 */

static int allocs = 0,
           frees  = 0,
	   max    = 0;

static nodePoint_t * freeList = NULL;

nodePoint_t * createNodePoint (x, y, subnodes)
coor_t x, y;
int * subnodes;
{
    static unsigned size;

    nodePoint_t * point;
    subnode_t ** cons;
    int i;
    char * p;


    if (freeList == NULL) {
	if (size == 0) {
	    size = sizeof (nodePoint_t) 
		 + nrOfExtConductors * sizeof (subnode_t *) 
		 + nrOfExtConductors * sizeof (subnode_t)
		 ;
	}
	/* Next NEW works only when
	 * ASSERT (sizeof (char) == 1);
	 */
	freeList = (nodePoint_t *) NEW (char, size);
	freeList -> next = NULL;
    }

    p = (char *) freeList;
    freeList = freeList -> next;

    point = (nodePoint_t *) p;
    point -> fixed = 0;
    point -> x = x;
    point -> y = y;
    point -> next = NULL;

    p += sizeof (nodePoint_t);

    point -> cons = cons = (subnode_t **) p;

    p += nrOfExtConductors * sizeof (subnode_t *);

    for (i = 0; i < nrOfExtConductors; i++) {
	if (subnodes[i] == 0)
	    cons[i] = NULL;
	else {
	    cons[i] = (subnode_t *) p;
	    cons[i] -> next_node = NULL;
	    p += sizeof (subnode_t);
	}
    }
    ASSERT (p <= (char *) point + size);

    if (++allocs - frees > max) max = allocs - frees;

    return (point);
}

void disposeNodePoint (point)
nodePoint_t * point;
{
    frees++;
    point -> next = freeList;
    freeList = point;
}

void nodePointStatistics (fp)
FILE * fp;
{
    fprintf (fp, "\tnodePoints allocated    : %d\n", allocs);
    if (frees != allocs)
	fprintf (fp, "\tnodePoints freed        : %d\n", frees);
    fprintf (fp, "\tmax nodePoints in core  : %d\n", max);
}

#ifdef DRIVER
int nrOfExtConductors = 3;
main () {
    int i, j, k;
    static int cons[] = {1, 0, 1};

    nodePoint_t * p[10];

    for (j = 0; j < 10; j++)
	p[j] = createNodePoint (j, j+1, cons);

    for (j = 0; j < 10; j++) {
	for (i = 0; i < nrOfExtConductors; i++) {
	    if (p[j] -> cons[i]) {
		fprintf (stderr, "i=%d x=%d y=%d\n",
		    i, p[j] -> cons[i] -> x, p[j] -> cons[i] -> y);
	    }
	}
    }

    for (j = 0; j < 10; j++)
	disposeNodePoint (p[j]);

    nodePointStatistics (stderr);
}
#endif /* DRIVER */
