static char *SccsId = "@(#)ready.c 4.6 (TU-Delft) 06/01/93";
/**********************************************************

Name/Version      : space/4.6

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include "include/config.h"
#include "include/type.h"
#include "aux/aux.h"
#include "lump/define.h"
#include "lump/extern.h"

node_t **QN;
int QN_cnt;

node_t **QAG;
int QAG_cnt;

/* pre: group to which n belongs has become ready */
/* actions: RC model reduction for group is completed */
/*          group is outputed if adjacent groups are ready */
/*          adjacent groups are checked for outputting */

readyGroup (gn)
node_t *gn;
{
    int i;
    int adjReady;
    node_t *n;
    element_t *cap;
    group_t *ogr;

    ASSERT (Grp (gn) -> notReady == 0);

#ifdef DEBUG_NODES
    fprintf (fp_dbn, "\nReady group: %x\n", Grp (gn));

    debug_nodes_check (1);
#endif

    QN_cnt = 0;
    searchGroup (gn);

    for (i = 0; i < QN_cnt; i++) {
	QN[i] -> flag = 0;
    }


    if (QN_cnt > 0 && QN[0] -> pin == NULL) {
	outGroup (QN, QN_cnt);
    }
    

}

searchGroup (n)
node_t *n;
{
    element_t *con;

    n -> flag = 1;
    putQueueNodes (n);

}

putQueueNodes (n)
node_t *n;
{
    static int QN_size = 0;

    int i;
    int newQN_size;
    node_t **newQN;

    if (QN_cnt >= QN_size) {
	if (QN_size <= 0) {
	    newQN_size = 50;
	}
	else {
	    newQN_size = QN_size * 1.5;
	}
	newQN = NEW (node_t *, newQN_size);
	for (i = 0; i < QN_size; i++) {
	    newQN[i] = QN[i];
	}

        if (QN_size > 0)
	    DISPOSE (QN);
	QN = newQN;
	QN_size = newQN_size;
    }

    QN[ QN_cnt++ ] = n;
}

putQueueGroups (n)
node_t *n;
{
    static int QAG_size = 0;

    int i;
    int newQAG_size;
    node_t **newQAG;

    if (QAG_cnt >= QAG_size) {
	if (QAG_size <= 0) {
	    newQAG_size = 50;
	}
	else {
	    newQAG_size = QAG_size * 1.5;
	}
	newQAG = NEW (node_t *, newQAG_size);
	for (i = 0; i < QAG_size; i++) {
	    newQAG[i] = QAG[i];
	}

        if (QAG_size > 0)
	    DISPOSE (QAG);
	QAG = newQAG;
	QAG_size = newQAG_size;
    }

    for (i = 0; i < QAG_cnt; i++) {
	if (Grp (QAG[i]) == Grp (n))
	    return;
    }

    QAG[ QAG_cnt++ ] = n;
}

