static char *SccsId = "@(#)addDef.c 4.3 (TU-Delft) 05/26/92";
/**********************************************************

Name/Version      : tecc/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <dmincl.h>
#include "define.h"
#include "type.h"
#include "extern.h"

addDef ()    /* add default conditions */
{
    int i;

    /* for now, I think it is better not to add 
       the following default conditions */

    for (i = 0; i < con_cnt; i++) {
	addD (cons[i].cond);
    }

    for (i = 0; i < tor_cnt; i++) {
	addD (tors[i].cond);
    }

    for (i = 0; i < cap_cnt; i++) {
	addD (caps[i].cond);
    }

    for (i = 0; i < res_cnt; i++) {
	addD (ress[i].cond);
    }

    for (i = 0; i < vdim_cnt; i++) {
	addD (vdms[i].cond);
    }

    for (i = 0; i < shape_cnt; i++) {
	addD (shps[i].cond);
    }
}

addD (cond)
struct layCondRef *cond;
{
    struct layCondRef *c, *csearch, *newref;

    c = cond;

    while (c != NULL) {

	if (c -> layC -> lay -> occurrence == EDGE
	|| c -> layC -> lay -> occurrence == OTHEREDGE) {

	    csearch = cond;
	    while (csearch != NULL) {
		if (csearch -> layC -> lay -> mask == c -> layC -> lay -> mask
		&& csearch -> layC -> lay -> occurrence == SURFACE
		&& csearch -> layC -> present == c -> layC -> present) {
		    break;
		}

		csearch = csearch -> next;
	    }

	    if (csearch == NULL) {   
	    
	            /* no continuation of the edge layer
		       condition is specified for the surface,
		       so we assume (default) that it changes for the surface */

                ALLOC (newref, 1, struct layCondRef);
		newref -> next = c -> next;
		c -> next = newref;
		ALLOC (newref -> layC, 1, struct layerCond);
		newref -> layC -> present = ! c -> layC -> present;
		ALLOC (newref -> layC -> lay, 1, struct layer);
		newref -> layC -> lay -> mask = c -> layC -> lay -> mask;
		newref -> layC -> lay -> occurrence = SURFACE;

		c = newref;
		    
            }

        }

	c = c -> next;
    }
}
