static char *SccsId = "@(#)check.c 4.2 (TU-Delft) 08/28/90";
/**********************************************************

Name/Version      : tecc/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <dmincl.h>
#include "define.h"
#include "type.h"
#include "extern.h"

checkConnections ()   
{
    int i;

    for (i = 0; i < con_cnt; i++) {
	checkRes ("contact", i, cons[i].cond, SURFACE, cons[i].mask1);
	checkRes ("contact", i, cons[i].cond, SURFACE, cons[i].mask2);
    }

    for (i = 0; i < tor_cnt; i++) {
	checkRes ("capacitor", i, tors[i].cond, SURFACE, tors[i].g);
    }

    for (i = 0; i < cap_cnt; i++) {
	checkRes ("capacitor", i, caps[i].cond,
		  caps[i].pLay -> occurrence, caps[i].pLay -> mask);
	if (caps[i].nLay -> mask >= 0)
	    checkRes ("capacitor", i, caps[i].cond,
		      caps[i].nLay -> occurrence, caps[i].nLay -> mask);
    }
}

checkRes (elem, nr, condp, occur, resMask)
char *elem;
int nr;
struct layCondRef *condp;
int occur;
int resMask;
{
    int i;
    int resFound;
    char buf[160];

    /* at this moment, not all checks can properly be executed ! */

#ifdef ALLCHECKS
    if (occur == EDGE)
	swapEdgeSurface (condp);
#endif

    resFound = 0;

    for (i = 0; i < res_cnt && !resFound; i++) {
	if (ress[i].mask == resMask) {

#ifdef ALLCHECKS
	    if (isSubSet (condp, ress[i].cond)) {
#endif

		resFound = 1;

#ifdef ALLCHECKS
	    }
#endif

	}
    }

#ifdef ALLCHECKS
    if (occur == EDGE)
	swapEdgeSurface (condp);
#endif

    if (! resFound) {
	
	sprintf (buf, "Layer Condition Error :\n");
	sprintf (buf + strlen (buf), 
"   pins of %s nr. %d will not connect to a conductor layer\n",
	elem, nr + 1);

	fatalErr (buf);
    }
}

#ifdef ALLCHECKS
swapEdgeSurface (cp)
struct layCondRef *cp;
{
    while (cp) {

	if (cp -> layC -> lay -> occurrence == SURFACE)
	    cp -> layC -> lay -> occurrence = EDGE;
	else if (cp -> layC -> lay -> occurrence == EDGE)
	    cp -> layC -> lay -> occurrence = SURFACE;

	cp = cp -> next;
    }
}

isSubSet (cp, cpS)
struct layCondRef *cp;
struct layCondRef *cpS;
{
    int is;
    int layFound;
    struct layCondRef *cpfind;

    is = 1;
    while (cpS && is) {

	cpfind = cp;
	layFound = 0;
	while (cpfind && !layFound) {
	    
	    if (cpS -> layC -> lay -> mask == cpfind -> layC -> lay -> mask
	    && cpS -> layC -> lay -> occurrence 
	       == cpfind -> layC -> lay -> occurrence) {

		layFound = 1;
		if (cpS -> layC -> present != cpfind -> layC -> present)
		    is = 0;
	    }

	    cpfind = cpfind -> next;
	}

	if (!layFound)
	    is = 0;

	cpS = cpS -> next;
    }

    return (is);
}
#endif
