%{
/* SccsId = "@(#)lex.l 4.4 (TU-Delft) 04/21/93" */
/**********************************************************

Name/Version      : tecc/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/

#ifdef FLEX_SCANNER /* if this is GNU flex in stead of regular lex */
int yylineno = 0;
#define YYINCR(_count) yylineno += _count /* flex does not do this for us */
#else
#define YYINCR(_x)
#endif

%}
E		[DEde][-+]?[0-9]+
%%
"#"			{ while (input () != '\n') ; YYINCR(1); } 
"-"			{ return (MINUS); }
"="			{ return (EQUAL); }
"*"			{ return (MULT); }
"/"			{ return (DIV); }
"!"			{ return (NOT); }
"("			{ return (LPS); }
")"			{ return (RPS); }
":"			{ return (COLON); }
"|"			{ return (BAR); }
"keys"			{ return (KEYS); }
"maxkeys"		{ return (MAXKEYS); }
"conductors"		{ return (CONDUCTORS); }
"transistors"		{ return (TRANSISTORS); }
"contacts"		{ return (CONTACTS); }
"capacitances"		{ return (CAPACITANCES); }
"vdimensions"		{ return (VDIMENSIONS); }
"eshapes"		{ return (ESHAPES); }
"cshapes"		{ return (CSHAPES); }
"unit"			{ return (UNIT); }
"resistance"		{ return (RESISTANCE); }
"c_resistance"		{ return (C_RESISTANCE); }
"capacitance"		{ return (CAPACITANCE); }
"a_capacitance"		{ return (A_CAPACITANCE); }
"e_capacitance"		{ return (E_CAPACITANCE); }
"vdimension"		{ return (VDIMENSION); }
"shape"			{ return (SHAPE); }
[a-zA-Z_][a-zA-Z0-9_]*	{ yylval.sval = (char *)yytext; return (IDENTIFIER); }
("-")?[0-9]+		{ yylval.ival = atoi (yytext); return (INTEGER); }
("-")?[0-9]+("."[0-9]+)?({E})?[fpnumkMG]?	{ 
			char c = yytext[ yyleng - 1 ];
			if (c >= '0' && c <= '9')
			    yylval.dval = atof (yytext);
			else {
			    yytext[ yyleng - 1 ] = '\0';
			    switch (c) {
			 	case 'G': yylval.dval = 1e6 * atof (yytext);
					  break;
			 	case 'M': yylval.dval = 1e6 * atof (yytext);
					  break;
			 	case 'k': yylval.dval = 1e3 * atof (yytext);
					  break;
			 	case 'm': yylval.dval = 1e-3 * atof (yytext);
					  break;
			 	case 'u': yylval.dval = 1e-6 * atof (yytext);
					  break;
			 	case 'n': yylval.dval = 1e-9 * atof (yytext);
					  break;
			 	case 'p': yylval.dval = 1e-12 * atof (yytext);
					  break;
			 	case 'f': yylval.dval = 1e-15 * atof (yytext);
					  break;
			    }
			}
			return (DOUBLE); 
			}
[\t ]+		        ;
[\n]+                   {YYINCR(yyleng);}

