/*
 * Verilog Behavioral Simulator version 1.0.0
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/* File:  eqeq.v */
module main;
	reg [0:3] a,b,c;

	initial
		begin
		a = 10;  /* initialize variables */
		b = 5;
		c = 15;
		#2 if (c != b) 
			begin
			c = ~c + 11;		/* c = 1011b */
			b = ~4'b0 + 1;		/* b = 0 */
			end
		#3 if (a != c)
			begin
			a = 9;			/* a = 1001b */
			if (c[1:2] == a[2:3])
				begin
				a = 0;
				b = a;		/* a = b = 0 */
				end
			end
		#4 if (a == 0)
			begin
			a = ~a;	/* a = 15 */
			c = 9;	/* c = 9 */
			end
		#4 if (c != 9)
			$write("4. Passing a false test!\n");
		$write("Actual results:\n");
		$write("time 0: (1010, 0101, 1111)\n");
		$write("time 2: (1010, 0000, 1011)\n");
		$write("time 5: (0000, 0000, 1011)\n");
		$write("time 9: (1111, 0000, 1001)\n");
		#1 $finish;
		end

	always @(a or b or c)
			$write("time %d: %b %b %b\n",$time,a,b,c);

endmodule
