/*
 * Verilog Behavioral Simulator version 1.0.0
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */

/*
 * Test basic function call with input/output arguments.
 */
module main;
	reg [7:0] a, b, c, d;

function [7:0] testfunc;
	input [7:0] x, y;
	output [7:0] z;
	reg [7:0] z;
	begin
	z = x + y;
	testfunc = z + x;
	$write("testfunc %d: %d %d %d\n", $time, x, y, z);
	end
endfunction

	initial
		begin
		$write("%d: %d %d %d %d (x x x x)\n",$time,a,b,c,d);
		#1 a = 4;
		$write("%d: %d %d %d %d (4 x x x)\n",$time,a,b,c,d);
		#1 b = 6;
		$write("%d: %d %d %d %d (4 6 x x)\n",$time,a,b,c,d);
		#1 c = testfunc(a, b, d);
		$write("%d: %d %d %d %d (4 6 14 10)\n",$time,a,b,c,d);
		#1 c = testfunc(d, a, b);
		$write("%d: %d %d %d %d (4 14 24 10)\n",$time,a,b,c,d);
		end

	always @(a)
		$write("monitor %d: a changed to %d\n", $time, a);
	always @(b)
		$write("monitor %d: b changed to %d\n", $time, b);
	always @(c)
		$write("monitor %d: c changed to %d\n", $time, c);
	always @(d)
		$write("monitor %d: d changed to %d\n", $time, d);

endmodule
