/*
 * Verilog Behavioral Simulator version 1.0.0
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/* File: logor.v */
/* 0: 13, 8, 3, 11 */
/* 2: 085 170 255 011 */
module main;
	reg [0:8] a,b,c,d;

	initial
		begin
		a = 13;				/* 1101 */
		b = 8;				/* 1000 */
		c = 3;				/* 0011 */
		d = c | b & a;			/* c|(b&a) = 1011 = 11 */
		#2 if (c & (a | !b))
			begin
			a = 85;			/* 55h */
			b = 170;			/* AAh */
			c = a | b;		/* FFh = 255 */
			end
		#3 if (!c)
			$write("Passing a false test!!\n");
		else
			$write("Test ok...\n");
		#1 $write("0: 13 8 3 11\n");
		$write("2: 85 170 255 11\n");
		#1 $finish;
		end

	always @(a or b or c or d)		
		$write("monitor %d: %d %d %d %d\n",$time,a,b,c,d);

endmodule
