/*
 * Verilog Behavioral Simulator version 1.0.0
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * Multiplier from Hennessy [94].  First iteration.
 */

module main /* (prod, finished, mcand, mplier, reset, clk) */;
	/*
	 * Port declaration for synthesis and internal registers.
	 * Remove comments to synthesize.
	 */
//	out [63:0] prod;
//	out finished;
//	in [31:0] mcand, mplier;
//	in clk, reset;
	reg [63:0] prod, mcand_copy;
	reg [31:0] mplier_copy;
	reg [7:0] working;
	reg finished;

/* **** Simulation registers and description, remove to synthesize. **** */

	reg [31:0] mplier, mcand;
	reg clk, reset;

	initial
		begin
		clk = 0;
		mcand = 14;
		mplier = 13;
		reset = 0;
		#1 reset = 1;
		#4 reset = 0;	// Must set reset for one clock cycle.
		end

	always #1 clk = !clk;

	always @(posedge finished)
		begin
		$write("Finished at %d:  %d * %d = %d\n",
			$time, mcand, mplier, prod);
		$finish;
		end

/* ************** End of simulation description. ********************* */


/*
 * Description of Multiplier starts here.  Remove or comment the above
 * simulation description to synthesize this module.  Don't forget to
 * uncomment the port declarations.
 */

	always @(posedge clk)
		begin
		if (reset == 1)
			begin
			prod = 0;
			mcand_copy = 0;
			mplier_copy = 0;
			finished = 0;
			working = 1;	// Start work on next clk!
			end
		else
			begin
			if (working == 1)
				begin
				// Make copies of the data.
				mcand_copy = mcand;
				mplier_copy = mplier;
				working = working + 1;
				end
			else if (working > 1)
				begin
				// Basic grade school multiplying.
				if (mplier_copy[0:0] == 1)
					prod = prod + mcand_copy;
				mcand_copy = mcand_copy << 1;
				mplier_copy = mplier_copy >> 1;	// Next bit.

				// When are we finished?
				if (working > 32)
					finished = 1;
				working = working + 1;
				end
			end
		end

endmodule
