/*
 * Verilog Behavioral Simulator version 1.0.0
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * Multiplier from Hennessy [94].  First iteration.
 */
module main;

	reg [31:0] mplier, mcand;
	reg clk, reset;
	wire [63:0] prod;
	wire finished;

	multv3a m3a (prod, finished, mcand, mplier, reset, clk);

	initial
		begin
		clk = 0;
		mcand = 29;
		mplier = 17;
		reset = 0;
		#1 reset = 1;
		#3 reset = 0;	// Must set reset for one clock cycle.
		end

	always #1 clk = !clk;

	always @(posedge finished)
		begin
		$write("Finished at %d:  %d * %d = %d (493)\n",
			$time, mcand, mplier, prod);
		$finish;
		end

endmodule
