/*
 * Verilog Behavioral Simulator version 1.0.0
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/* Test nested blocks. */
module main;
	reg [0:3] a,b,c;

	initial
		begin
		a = 0;
		#1 b = 0;
		#1 c = 0;
		#1 if (1)
			begin
			#1 a = ~a;	/* a = 15 */
			#1 b = 8;	/* b = 8 */
			#1 c = ~b;	/* c = 7 */
			end
		$write("end of first if %d: %d %d %d (15 8 7)\n",
			$time,a,b,c);
		#1 if (1)
			begin
			#1 a = 1;	/* a = 1 */
			#1 b = 2;	/* b = 2 */
			#1 c = 3;	/* c = 3 */
			end
		$write("end of second if %d: %d %d %d (1 2 3)\n",
			$time,a,b,c);
		end

	always @(a or b or c)
		$write("monitor %d: %d %d %d\n",$time,a,b,c);
endmodule
