/*
 * Verilog Behavioral Simulator version 1.0.0
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/* Test range selection of registers. */
module main;
	reg [7:0] a, c;
	reg [0:7] b;

	initial
		begin
		a = 8'b1010_1000;
		b = 8'b1010_1000;
		$write("a=%b (0101), b=%b (0100)\n", a[6:3], b[3:6]);
		$write("a=%b (1), b=%b (1)\n", a[3:3], b[0:0]);

		a = 0; a[4:3] = 2;		/* a = 0001_0000 */
		b = 0; b[3:4] = 1;		/* b = 0000_1000 */
		c = 0; c[4:3] = 1;		/* c = 0000_1000 */
		$write("a=%b (0001_0000) b=%b (0000_1000) c=%b (0000_1000)\n",
			a,b,c);
		$write("a[6:2] = b[1:3](%b) + c[6:2](%b)\n", b[1:3], c[6:2]);
		/* 000(0) + 00010(2) = 010(2) */
		a[6:2] = b[1:3] + c[6:2];
		$write("a=%b (0000_1000)\n", a);
		b = a;
		$write("b=%b (0000_1000)\n", b);
		end

endmodule
