/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * Display.cc
 *
 * Same attempt to seperate PTypes.h.  This file contains all display
 * virtual member functions.
 */

#include <iostream.h>
#include "Base.h"		// DelayNum needs Convert().
#include "PExpr.h"
#include "PTypes.h"

ostream &
ConstExpression::display(ostream &s)
	{ s << amt; return s; }

ostream &
RangeId::display(ostream &s)
	{
	s << name;
	if (flag)
		s << range;
	return s;
	}

ostream &
NotOp::display(ostream &s)
	{
	s << '!' << *exp;
	return s;
	}

ostream &
InvertOp::display(ostream &s)
	{
	s << '~' << *exp;
	return s;
	}

ostream &
AddOp::display(ostream &s)
	{
	s << *exp1 << " + " << *exp2;
	return s;
	}

ostream &
SubOp::display(ostream &s)
	{
	s << *exp1 << " - " << *exp2;
	return s;
	}

ostream &
EqEqComp::display(ostream &s)
	{
	s << *exp1 << " == " << *exp2;
	return s;
	}

ostream &
NotEqComp::display(ostream &s)
	{
	s << *exp1 << " != " << *exp2;
	return s;
	}

ostream &
OrOrOp::display(ostream &s)
	{
	s << *exp1 << " || " << *exp2;
	return s;
	}

ostream &
AndAndOp::display(ostream &s)
	{
	s << *exp1 << " && " << *exp2;
	return s;
	}

ostream &
LogOrOp::display(ostream &s)
	{
	s << *exp1 << " | " << *exp2;
	return s;
	}

ostream &
LogAndOp::display(ostream &s)
	{
	s << *exp1 << " & " << *exp2;
	return s;
	}

ostream &
LogLShiftOp::display(ostream &s)
	{
	s << *exp1 << " << " << *exp2;
	return s;
	}

ostream &
LogRShiftOp::display(ostream &s)
	{
	s << *exp1 << " >> " << *exp2;
	return s;
	}

ostream &
GrtThanOp::display(ostream &s)
	{
	s << *exp1 << " > " << *exp2;
	return s;
	}

ostream &
GrtEqOp::display(ostream &s)
	{
	s << *exp1 << " >= " << *exp2;
	return s;
	}

ostream &
LesThanOp::display(ostream &s)
	{
	s << *exp1 << " < " << *exp2;
	return s;
	}

ostream &
LesEqOp::display(ostream &s)
	{
	s << *exp1 << " <= " << *exp2;
	return s;
	}

ostream &
DelayNum::display(ostream &s)
	{ s << '#' << Convert(amt, 10); return s; }

ostream &
DelayRangeId::display(ostream &s)
	{ s << '#' << id; return s; }

ostream &
OredEvntExpression::display(ostream &s)
	{ s << "@(" << vars << ')'; return s; }

ostream &
NullStmt::display(ostream &s)
	{
	s << "This is a null statement..." << endl;
	return s;
	}

ostream &
AssignStmt::display(ostream &s)
	{
	if (dec)
		s << *dec << ' ';
	s << lval << '=' << *rval << endl;
	return s;
	}

ostream &
SeqBlkStmt::display(ostream &s)
	{
	if (dec)
		s << *dec << ' ';
	s << "begin" << endl;
	s << '\t' << stmts << endl;
	s << "end" << endl;
	return s;
	}

ostream &
IfStmt::display(ostream &s)
	{
	if (dec)
		s << *dec << ' ';
	s << "if (" << *expr << ')' << endl;
	s << '\t' << *stmt << endl;
	return s;
	}

ostream &
IfElseStmt::display(ostream &s)
	{
	if (dec)
		s << *dec << ' ';
	s << "if (" << *expr << ')' << endl;
	s << '\t' << *stmt1 << endl;
	s << "else" << endl;
	s << '\t' << *stmt2 << endl;
	return s;
	}

ostream &
ForStmt::display(ostream &s)
	{
	if (dec)
		s << *dec << ' ';
	s << "for (" << assign1 << "; " << *expr;
	s << "; " << assign2 << ')';
	s << '\t' << *stmt << endl;
	return s;
	}

ostream &
CaseItem::display(ostream &s)
	{
	if (def)
		s << "default";
	else
		s << expr;
	s << " : " << *stmt << endl; 
	return s;
	}

ostream &
CaseStmt::display(ostream &s)
	{
	s << endl;
	if (dec)
		s << *dec << ' ';
	s << "case (" << *expr << ')' << endl;
	s << '\t' << ci << endl;
	if (def)
		s << def << endl;
	s << "endcase" << endl;
	return s;
	}

ostream &
NullModuleItem::display(ostream &s)
	{
	s << "This is a null module item...";
	return s;
	}

ostream &
NullTFDecl::display(ostream &s)
	{
	s << "This is a null tf declaration...";
	return s;
	}

ostream &
WireDecl::display(ostream &s)
	{
	s << "wire " << range << ' ' << ids << endl;
	return s;
	}

ostream &
RegDecl::display(ostream &s)
	{
	s << "reg " << range << ' ' << ids << endl;
	return s;
	}

ostream &
InputDecl::display(ostream &s)
	{
	s << "input " << range << ' ' << ids << endl;
	return s;
	}

ostream &
OutputDecl::display(ostream &s)
	{
	s << "output " << range << ' ' << ids << endl;
	return s;
	}

ostream &
InoutDecl::display(ostream &s)
	{
	s << "inout " << range << ' ' << ids << endl;
	return s;
	}

ostream &
Function::display(ostream &s)
	{
	s << "function " << retsize << ' ' << name << ';' << endl;
	s << decl << endl;
	s << *stmt;
	return s;
	}

ostream &
Task::display(ostream &s)
	{
	s << "task " << name << ';' << endl;
	s << decl << endl;
	s << *stmt;
	return s;
	}

ostream &
InitialStmt::display(ostream &s)
	{ s << *stmt; return s; }

ostream &
AlwaysStmt::display(ostream &s)
	{ s << *stmt; return s; }

ostream &
ModuleInstance::display(ostream &s)
	{
	s << name << '(' << connections << ')';
	return s;
	}

ostream &
ModuleInstan::display(ostream &s)
	{
	s << modname << instances << endl;
	return s;
	}
