/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * Error.h
 *
 * Error handler.  To add a new error to detect, include a message in
 * <Sim_errmsg> (Error.cc), and add a define in <Errno>.
 */

#ifndef ERROR_H
#define ERROR_H

#include <stdarg.h>
#include "Bool.h"
#include "String.h"

/*
 * Flag to determine the error type and exit status.
 */
enum Errflag
	{
	SEF_EXIT	= 0x01,	// This error causes an exit.
	SEF_COMP	= 0x10,	// Compilation error.
	SEF_SIM		= 0x20,	// Simulation error.
	SEF_SETUP	= 0x40	// Setup error.
	};

enum Errno
	{
	// General Errors...
	SE_NONE,		// No errors or warnings.
	SE_SUPPORT,		// Construct not yet supported.
	SE_INTERNAL,		// Internal simulator error.
	SE_NTOPLVL,		// No top-level module found.
	SE_RANGE,		// Invalid Range.
	SE_IDXORDER,		// Order of indices are wrong.
	SE_MULTDEF,		// Only one default case is allowed.
	SE_TYPE,		// Invalid type for this usage.
	SE_NLVAL,		// Not an lvalue.
	SE_REPEAT,		// Repeated operation.
	SE_COMPLETE,		// Incomplete type, needs storage area.

	// Errors related to symbol table.
	SE_STINIT,		// Symbol table not initialized.
	SE_STFULL,		// Symbol table is full.
	SE_STDUP,		// Duplicate symbol in symbol table.
	SE_STDEF,		// Symbol not found.

	// Parser errors.
	SE_PSYMBOL,		// Unexpected symbol.
	SE_PKEYWORD,		// Unexpected keyword.
	SE_PEOF,		// Unexpected end of file.

	// Errors related to task and function calls.
	SE_NTASK,		// Not a task or system task.
	SE_NFUNCTION,		// Not a function or system function.
	SE_NARGLST,		// Wrong number of arguments.
	SE_FMTSPEC,		// Missing type specifier in format string.
	SE_FMTUNKN,		// Unknown type specifier in format string.
	SE_FMTSYM,		// Invalid symbol in format string.
	SE_FMTNOTERM		// No termination in format string.
	};

extern String Sim_programname;	// Our name to the system.
extern String Sim_filename;	// File name with error.
extern int Sim_lineno;		// Line number of error.
extern Errno Sim_errno;		// Error value.

void Sim_perror(int, char *, ...);
void Sim_seterror(Errno, String &, int);

#endif // ERROR_H
