/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * Eval.cc
 *  
 * To do the evaluation of the expression
 */

#include "Bool.h"
#include "Bitvector.h"		// Convert SubBitVector to BitVector
#include "Error.h"
#include "Symtab.h"
#include "TWheel.h"
#include "Base.h"		// Number
#include "PExpr.h"

extern TimeWheel<Stmts *> timewheel;

Number
ConstExpression::Sim_evaluate(void)
	{ return amt; }

Number
RangeId::Sim_evaluate(void)
	{
	STnode *tmp = symboltable[idx];
	Number val = tmp->Sim_evaluate();
	if (flag)
		{
		Number lnum, rnum;
		GetRangeData(range, lnum, rnum);
		unsigned long ms = lnum;
		unsigned long ls = rnum;
		// Setup already checked for valid range.
		BitVector n = val(ms, ls);	// Returns SubBitVector.
		return n;
		}
	return val;
	}

Number
NotOp::Sim_evaluate(void)
	{
	Number val;
	val = exp->Sim_evaluate();
	return (unsigned long)(!val);
	}

Number
InvertOp::Sim_evaluate(void)
	{
	Number num;
	num = exp->Sim_evaluate();
	return ~num;
	}

Number
AddOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (num1 + num2);
	}

Number
SubOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (num1 - num2);
	}

Number
EqEqComp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	if (num1 == num2)
		return (unsigned long) TRUE;
	return (unsigned long) FALSE;
	}

Number
NotEqComp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	if (num1 != num2)
		return (unsigned long) TRUE;
	return (unsigned long) FALSE;
	}

Number
OrOrOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	if (num1 != FALSE || num2 != FALSE)
		return (unsigned long) TRUE;
	return (unsigned long) FALSE;
	}

Number
AndAndOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	if (num1 != FALSE && num2 != FALSE)
		return (unsigned long) TRUE;
	return (unsigned long) FALSE;
	}
  
Number
LogOrOp::Sim_evaluate(void)
 	{
 	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (num1 | num2);
	}

Number
LogAndOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (num1 & num2);
	}
 
Number
LogLShiftOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (num1 << num2);
	}

Number
LogRShiftOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (num1 >> num2);
	}

Number
GrtThanOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (unsigned long)(num1 > num2);
	}

Number
GrtEqOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (unsigned long)(num1 >= num2);
	}

Number
LesThanOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (unsigned long)(num1 < num2);
	}

Number
LesEqOp::Sim_evaluate(void)
	{
	Number num1, num2;
	num1 = exp1->Sim_evaluate();
	num2 = exp2->Sim_evaluate();
	return (unsigned long)(num1 <= num2);
	}
