/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * Main.cc
 *
 * Main driver.
 */

#include <unistd.h>		// getopt
#include <iostream.h>
#include "Error.h"		// Sim_programname
#include "glo.h"		// Sim_start, etc...

void
syntax(void)
	{
	cout << endl << "syntax: "
		<< Sim_programname << " [-h] filename ..."
		<< endl << endl;
	}

int
sys_init(char *pn)
	{
	// Initialize system variables (globals).
	Sim_init(pn);
	return 1;
	}

int
sys_debug(char *fn)
	{
	Sim_debug(fn);
	return 1;
	}

int
main(int argc, char *argv[])
	{
	char c;

	if (!sys_init(argv[0]))
		return 1;

	if (argc < 2)
		{
		syntax();
		return 1;
		}

	c = getopt(argc, argv, ":h");
	while (c != -1)
		{
		switch(c)
			{
			case 'h':
			case '?':
				syntax();
				return 0;
			}
		c = getopt(argc, argv, ":h");
		}

	if (!p_init(argc - optind, &argv[optind]))
		return 1;

	// Here we go!
	p_start();	// First, parse all files.

	// Finished parsing all files, now simulate.
	Sim_start();

	return 0;
	}
