/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * String.cc
 *
 * String class.
 */

#include <string.h>
#include "String.h"

String::String(char *str, int len)
	{
	if (str == NULL && len < 0)
		{
		size = 0;
		data = NULL;
		}
	else
		{
		if (len > 0)
			size = len;		// Use <len> if given.
		else
			size = strlen(str);	// Find default.
		data = new char[size+1];
		if (str != NULL)
			strcpy(data,str);
		else
			// Zero out <data> if no string is given.
			memset(data, '\0', size+1);
		}
	}

String::String(String &str)
	{
	if (str.size == 0)
		{
		size = 0;
		data = NULL;
		}
	else
		{
		size = str.size;
		data = new char[size+1];
		strcpy(data,str.data);
		}
	}

String &
String::operator=(String &str)
	{
	if(data)
		delete [] data;		// The data of "this".
	if (str.size == 0)
		{
		size = 0;
		data = NULL;
		}
	else
		{
		size = str.size;
		data = new char[size+1];
		strcpy(data,str.data);
		}
	return *this;
	}

String
operator+(String &l, String &r)
	{
	String str(NULL, l.size + r.size);

	strcpy(str.data,l.data);
	strcat(str.data,r.data);
	return str;
	}

int
operator==(String &l, String &r)
	{ return (strcmp(l.data,r.data) == 0); }

int
operator==(String &l, char *r)
	{
	if (l.data == r)
		return 1;
	else if (l.data == NULL || r == NULL)
		// Not pointing to same array, but one is NULL.
		return 0;
	return (strcmp(l.data,r) == 0);
	}

int
operator!=(String &l, String &r)
	{ return (strcmp(l.data,r.data) != 0); }

int
operator!=(String &l, char *r)
	{
	if (l.data == r)
		return 0;
	else if (l.data == NULL || r == NULL)
		return 1;
	return (strcmp(l.data,r) != 0);
	}

int
operator>(String &l, String &r)
	{ return (strcmp(l.data,r.data) > 0); }

int
operator>=(String &l, String &r)
	{ return (strcmp(l.data,r.data) >= 0); }

int
operator<(String &l, String &r)
	{ return (strcmp(l.data,r.data) < 0); }

int
operator<=(String &l, String &r)
	{ return (strcmp(l.data,r.data) <= 0); }

String &
Strset(String &str, char c)
	{
	memset(str.data,c,str.size);
	return str;
	}

int
Length(String &str)
	{ return str.size; }

ostream &
operator<<(ostream &s, String &str)
	{
	for(int i=0; i < Length(str); i++)
		s << str[i];
	return s;
	}

ostream &
operator<<(ostream &s, String *str)
	{
	if (str != NULL)
		s << *str;
	return s;
	}
