/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * String.h
 *
 * String class.  Until ISO adopts a standard string class, we'll be using
 * our own.  But we will use the standard when it is finished.  A simple
 * replacement of this header file with one that typedef'ed the string
 * class to 'String', should work.
 */

#ifndef STRING_H
#define STRING_H

#include <iostream.h>
#include <stdio.h>
#include <string.h>

class String {
	int size;
	char *data;
public:
	String(char * = NULL, int = -1);
	String(String &);
	~String()
		{ if (data) delete [] data; }
	operator char *(void)
		{ return data; }
	String &operator=(String &);
	char &operator[](int idx) { return data[idx]; }
	friend String operator+(String &, String &);
	friend int operator==(String &, String &);
	friend int operator==(String &, char *);
	friend int operator!=(String &, String &);
	friend int operator!=(String &, char *);
	friend int operator>(String &, String &);
	friend int operator>=(String &, String &);
	friend int operator<(String &, String &);
	friend int operator<=(String &, String &);
	friend String &Strset(String &, char);
	friend int Length(String &);
	};

extern ostream &operator<<(ostream &, String &);
// Used in a link list where we can not dereference a pointer.
extern ostream &operator<<(ostream &, String *);

#endif // STRING_H
