/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * Systask.h
 *
 * Class to keep track of all System tasks.
 */

#ifndef SYSTASK_H
#define SYSTASK_H

#include <iostream.h>
#include "Bool.h"
#include "String.h"
#include "List.h"		// TaskStmt
#include "Symtab.h"		// HashValue
#include "Base.h"
#include "PExpr.h"		// RangeId

/*
 * Classes to put into the symbol table.
 */
class SysTaskWrite : public Stmts
	{
	String name;
public:
	SysTaskWrite()
		: name("$write") {}
	void Sim_setup(Stack<int> &, Bool = FALSE, int = NS_ALL);
	int Sim_trigger(Stmts *);
	};

class SysTaskFinish : public Stmts
	{
	String name;
public:
	SysTaskFinish()
		: name("$finish") {}
	void Sim_setup(Stack<int> &, Bool = FALSE, int = NS_ALL);
	int Sim_trigger(Stmts *);
	};

class SysFunctionTime : public Expression
	{
	String name;
public:
	SysFunctionTime()
		: name("$time") {}
	void Sim_setup(Stack<int> &);
	void Sim_trigger(String &);
	Number Sim_evaluate(void);
	};

/* System function:  $time */
class FunctionCall : public Expression
	{
	RangeId name;
	List<Expression *> args;
public:
	HashValue idx;			// Index into symbol table.
	FunctionCall(RangeId &id)
		: name(id) {}
	FunctionCall(RangeId &id, List<Expression *> &arg)
		: name(id), args(arg) {}
	FunctionCall(FunctionCall &sfe)
		: Expression(sfe), name(sfe.name), args(sfe.args) {}
	ostream &display(ostream &);
	Expression *copy(void);
	void Sim_setup(Stack<int> &);
	void Sim_trigger(String &);
	Number Sim_evaluate(void);
	friend ostream &operator<<(ostream &s, FunctionCall &sf)
		{ return sf.display(s); }
	};

/* System task:  $write, $finish, etc... */
class TaskStmt : public Stmts
	{
	friend class SysTaskWrite;

	RangeId name;			// Name of system task w/ '$'
	List<Expression *> args;	// String constant for format
					// and list of arguments
public:
	HashValue idx;			// Index into symbol table.
	TaskStmt(RangeId &id)
		: name(id) {}
	TaskStmt(RangeId &id, List<Expression *> &arg)
		: name(id), args(arg) {}
	TaskStmt(TaskStmt &st)
		: Stmts(st), name(st.name), args(st.args) {}
	ostream &display(ostream &);
	Stmts *copy(void);
	void Sim_setup(Stack<int> &, Bool = FALSE, int = NS_ALL);
	int Sim_trigger(Stmts *);
	friend ostream &operator<<(ostream &s, TaskStmt &sts)
		{ return sts.display(s); }
	};

#endif // SYSTASK_H
