/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * TWheel.h
 *
 * Time wheel class.  This class is a template class for the same reason
 * as the "Events" class.  See Event.h for an explanation.
 */

#ifndef TWHEEL_H
#define TWHEEL_H

#include <iostream.h>		// cout debug statements, remove later...
#include "List.h"

template<class T> class TimeWheel;

/*
 * Time Wheel node.
 */
template<class T>
class TWnode
	{
	friend class TimeWheel<T>;

	unsigned long time;		// Current time for this node.
						// Absolute time.
	List<T> ops;			// List of operations.
	TWnode<T> *next;		// Next time event.
public:
	TWnode()
		: time(0UL)
		{ next = NULL; }
	TWnode(T op, unsigned long abs_time = 0)
		: time(abs_time)
		{
		ops += op;
		next = NULL;
		}
	TWnode(TWnode<T> &tw)
		: time(tw.time), ops(tw.ops)
		{ next = tw.next; }
	TWnode<T> &operator+=(TWnode<T> &tw)
		{
		// If this operation belongs in this time unit, append it
		// to <ops>.
		if (tw.time == time)
			{
#if defined(DEBUG_FUTR)
cout << "DEBUG_FUTR:  appending to current time: " << tw.time << endl;
#endif
			ops += tw.ops;
			}
		else if (tw.time > time)
			{
			// Greater than current time unit.
			// Could insert if less than next time unit, or append
			// after next time unit.  In case <next> is NULL, we
			// just append.
			if (next != NULL)
				{
				// Between this time unit and next time
				// unit, insert.
				if (tw.time < next->time)
					{
#if defined(DEBUG_FUTR)
cout << "DEBUG_FUTR: inserting to time unit: " << tw.time << endl;
#endif
					TWnode *tmp = new TWnode<T>(tw);
					tmp->next = next;
					next = tmp;
					}
				// Greater than next time unit, append.
				else
					*next += tw;
				}
			// Hmm, at the end of our list, append.
			else
				{
#if defined(DEBUG_FUTR)
cout << "DEBUG_FUTR: appending to time unit: " << tw.time << endl;
#endif
				next = new TWnode<T>(tw);
				}
			}
		else
			cout << "Less than current time (Error)?" << endl << endl;
		return *this;
		}
	void Sim_trigger(void)
		{
		T tmp;
		// Trigger the operations in this time event.

#if defined(DEBUG_TW)
cout << "DEBUG_TW: Starting event time " << time << "..." << endl << endl;
#endif
		Reset(ops);
		while(Data(ops, tmp))
			{
			// Statements return TRUE for two reasons;  1.  it has
			// finished exec'ing or 2.  it is finished with one
			// nesting level.  Thus, we can't just delete this
			// statement without knowing which case it was.
#if defined(DEBUG_TW)
cout << "Executing next event..." << endl;
#endif
			tmp->Sim_trigger(tmp);
			}

#if defined(DEBUG_TW)
cout << endl;
#endif
		}
	};

/*
 * Time Wheel.  We can not use a List to store the nodes in this case
 * because we need to insert nodes.  Unless in the future we extend
 * the list class to include sorted lists.
 */
template<class T>
class TimeWheel
	{
	TWnode<T> *node;
public:
	TimeWheel()
		{ node = new TWnode<T>; }
	TimeWheel &operator+=(TWnode<T> &n)
		{ *node += n; return *this; }
	~TimeWheel()
		{
		TWnode<T> *tmp = node;
		for (; tmp != NULL; tmp = tmp->next)
			delete node;
		}
	void Sim_trigger(void (*handler)(void))
		{
		TWnode<T> *tmp;
		// Trigger our node.
		while (node != NULL)
			{
			node->Sim_trigger();
			(*handler)();
			tmp = node;
			node = node->next;
			delete tmp;
			}
		}
	friend unsigned long CurrentTime(TimeWheel<T> &tw)
		{ return tw.node->time; }
	};

#endif // TWHEEL_H
