/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
/*
 * glo.h
 *
 * Generic header file
 */

#ifndef GLO_H
#define GLO_H

#include "intrface.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Setup.cc */

extern void Sim_debug(char *);
extern void Sim_init(char *);
extern void Sim_start(void);
extern void parsed_module(p_Module *);
extern void p_perror(char *, char *, char *, char *, int);
extern char *my_strdup(const char *);
#if defined (__sun)			/* SUN bites the big one */
extern int getopt(int argc, char * const argv[], const char *optstring);
extern char *optarg;
extern int optind, opterr, optopt;
#endif

/*
 * Global data variables.
 */

extern FILE *yyin;			/* Input for yacc parser. */
extern int cur_lineno;			/* Line number of error. */
extern char *cur_filename;		/* File name of error. */
extern char *savedword;			/* Save keyword for error reporting. */
extern void yyerror(char *str);		/* Our version. */
extern int yywrap(void);		/* Our version. */
extern int yylex(void);			/* Lexer function. */
extern int yyparse(void);		/* Parse function. */

#define HASHSIZE 65537			/* Size of symbol table */
#define MAXBUF 4096			/* Max size of tmp buffer */

#ifdef __cplusplus
}
#endif

#endif /* GLO_H */
