/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
#include "Bitvector.h"

BitVector Zero(LO);
BitVector One(HI);

void
test_sqrebracket(BitVector &, BitVector &, BitVector &c,
		BitVector &, BitVector &)
	{
	c(0) = LO;
	c(1) = HI;
	c(2) = Z;
	c(3) = DC;
	c(4) = LO;
	cout << "c=" << c << " (==0xz10)"
		<< endl;
	}

void
test_equality(BitVector &, BitVector &, BitVector &c,
		BitVector &d, BitVector &)
	{
	BitVector test1(String("1101"));
	if (test1 == d)
		cout << "test1 == d (ok!)" << endl;
	if (test1 != d)
		cout << "test1 != d (not!)" << endl;
	if (test1 == c)
		cout << "test1 == c (not!)" << endl;
	if (test1 != c)
		cout << "test1 != c (ok!)" << endl;
	}

void
test_notop(BitVector &, BitVector &b, BitVector &,
		BitVector &, BitVector &)
	{
	if (!b)
		cout << "b is false (not!)" << endl;
	if (!(!b))
		cout << "b is true (ok!)" << endl;
	}

void
test_equal(BitVector &, BitVector &, BitVector &c,
		BitVector &d, BitVector &)
	{
	BitVector test1(0,2), test2(2,1);
	test1 = d;
	test2 = c;
	cout << "test1(0,2=d)=" << test1 << " (=101)"
		<< " test2(2,1=c)=" << test2 << " (=10)"
		<< endl;
	}

void
test_plus(BitVector &, BitVector &, BitVector &,
		BitVector &, BitVector &e)
	{
	BitVector test1(3,0), test2(4,0);

	test1 = e + One;
	test2 = e + e;
	cout << "test1(e+1)=" << test1 << " (=1110)"
		<< " test2(e+e)=" << test2 << " (=11010)"
		<< endl;
	}

void
test_minus(BitVector &, BitVector &, BitVector &,
		BitVector &, BitVector &e)
	{
	BitVector test1(3,0), test2(4,0);

	test1 = e - One;
	test2 = e - e;
	cout << "test1(e-1)=" << test1 << " (=1100)"
		<< " test2(e-e)=" << test2 << " (=00000)"
		<< endl;
	}

void
test_shift(BitVector &, BitVector &, BitVector &,
		BitVector &, BitVector &e)
	{
	BitVector test1(7,0), test2(3,0);

	test1 = e;
	test1 = test1 << 4;
	test2 = e << 2;
	cout << "test1(=e<<4)=" << test1 << " (=11010000)"
		<< " test2(e<<2)=" << test2 << " (=0100)"
		<< endl;

	test1 = test1 >> 4;
	test2 = e >> 2;
	cout << "test1(=e>>4)=" << test1 << " (=00001101)"
		<< " test2(e>>2)=" << test2 << " (=0011)"
		<< endl;
	}

void
test_logic(BitVector &, BitVector &, BitVector &,
		BitVector &, BitVector &e)
	{
	BitVector test1(3,0), test2(String("10110"));

	test1 = test2 | e;
	cout << "test1(test2|e)=" << test1 << " (=1111)" << endl;
	test1 = test2 & e;
	cout << "test1(test2&e)=" << test1 << " (=0100)" << endl;
	test1 = test2 ^ e;
	cout << "test1(test2^e)=" << test1 << " (=1011)" << endl;
	}

void
test_range(BitVector &, BitVector &, BitVector &,
		BitVector &d, BitVector &e)
	{
	BitVector test1(7,0);

	test1(6,5) = d(1,0);
	test1(4,1) = e;
	cout << "test1(6,5/4,1=d1,0/e)=" << test1 << " (=x101101x)"
		<< endl;
	}

void
test_conv(BitVector &, BitVector &, BitVector &,
		BitVector &d, BitVector &e)
	{
	BitVector test1(String("4567"), 8),
		test2(String("6789"), 10),
		test3(String("9abc"), 16);

	cout << "test1(8,4567)=" << test1 << endl
		<< "test2(d,6789)=" << test2 << endl
		<< "test3(h,9abc)=" << test3 << endl;
	}

void
test_comp(BitVector &, BitVector &, BitVector &,
		BitVector &, BitVector &)
	{
	BitVector test1(15UL), test2(25UL), test3(15UL);

	if (test1 < test2)
		cout << test1 << " < " << test2 << " Ok!" << endl;
	else
		cout << test1 << " !< " << test2 << " Not!" << endl;
	if (test1 <= test3)
		cout << test1 << " <= " << test3 << " Ok!" << endl;
	else
		cout << test1 << " !<= " << test2 << " Not!" << endl;
	}

void
printout(BitVector &a, BitVector &b, BitVector &c,
		BitVector &d, BitVector &e)
	{
	cout << "a=" << a
		<< " b=" << b
		<< " c=" << c
		<< " d=" << d
		<< " e=" << e
		<< endl;
	}

int
main()
	{
	BitVector a, b(HI), c(4,0), d(String("1101")), e(d), f(115UL);

	printout(a,b,c,d,e);
	test_sqrebracket(a,b,c,d,e);
	printout(a,b,c,d,e);
	test_equality(a,b,c,d,e);
	printout(a,b,c,d,e);
	test_notop(a,b,c,d,e);
	printout(a,b,c,d,e);
	test_equal(a,b,c,d,e);
	printout(a,b,c,d,e);
	d = b;
	test_plus(a,b,c,d,e);
	printout(a,b,c,d,e);
	d = c;
	test_minus(a,b,c,d,e);
	printout(a,b,c,d,e);
	test_shift(a,b,c,d,e);
	printout(a,b,c,d,e);
	test_logic(a,b,c,d,e);
	printout(a,b,c,d,e);
	test_range(a,b,c,d,e);
	printout(a,b,c,d,e);
	test_conv(a,b,c,d,e);
	printout(a,b,c,d,e);
	test_comp(a,b,c,d,e);
	printout(a,b,c,d,e);

	d = ~d;
	cout << "d inverted = " << d << " (=xx01)" << endl;
	e = e + d;
	cout << "e(e+d)=" << e << " (=xx10)" << endl;
	printout(a,b,c,d,e);

	BitVector tmp(String("101101101011"));
	String tmp1 = Convert(tmp, 8);
	String tmp2 = Convert(tmp, 10);
	String tmp3 = Convert(tmp, 16);
	cout << "101101101011:" << tmp << " "
		<< tmp1 << " "
		<< tmp2 << " "
		<< tmp3 << " "
		<< endl;

	cout << "f(115) = " << f << " (=1110011)"
		<< endl;

	return 0;
	}
