/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
#include <iostream.h>
#include "String.h"
#include "List.h"

int
main()
	{
	List<String *> ls, lt, lu, lv, *lw;
	String a("abc"), b("def"), c("123"), *data;
	ls += &a;
	ls += &b;
	ls += &c;
	ls += &b;
	ls += &a;
	lt = ls;
	lu += &b;
	lu += &c;
	lv = lt;
	lv += &a;
	lw = new List<String *>(lv);
	lv += lu;
	cout << "ls: " << ls << endl;
	cout << "ls: " << ls << endl;
	cout << "lt: " << lt << endl;
	cout << "lu: " << lu << endl;
	cout << "lv: " << lv << endl;
	cout << "lw: " << *lw << endl;
	Delete(lu);
	delete lw;
	cout << "lu after Delete(): " << lu << endl;
	// Originally, I tried outputing *lw.  But I just realized that lw
	// was a pointer that I've just deleted.  This SHOULD give me a
	// segfault.  Why didn't Sun and BSDI give me segfault, and Linux
	// did?
	lw = NULL;		// delete doesn't set lw to NULL?
	if (lw != NULL)
		cout << "lw after delete (BAD!!!): " << *lw << endl;
	else
		cout << "lw is null (GOOD!). " << endl;
	cout << "lv before Data(): ";
	while (Data(lv, data))
		cout << *data << ' ';
	cout << endl;
	cout << "lv after Data(): " << lv << endl;
	cout << "Using the operator[]: ";
	for (int i = 0; i < Size(ls); i++)
		{
		data = ls[i];
		cout << *data << ' ';
		}
	cout << endl;

	// Now test the stack class.
	Stack<String *> stk;
	cout << "Original stack: " << stk << endl;
	Push(stk, &a);
	Push(stk, &b);
	Push(stk, &c);
	cout << "After three nodes: " << stk << endl;
	
	return 0;
	}
