/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
#include <iostream.h>
#include "String.h"
#include "Symtab.h"

int
main()
	{
	symboltable.Init(65537);
	HashValue idx;

	STnode *tmp = new STnode(0, String("abc"));
	tmp->SetType(NT_WIRE);
	if (symboltable.Enter(tmp, idx) == STE_DUP)
		cout << "Dup! (should not happen)" << endl;
	else
		cout << "abc entered ok" << endl;

	tmp = new STnode(0, String("bcd"));
	tmp->SetType(NT_REG);
	if (symboltable.Enter(tmp, idx) == STE_DUP)
		cout << "Dup! (should not happen)" << endl;
	else
		cout << "bcd entered ok" << endl;

	tmp = new STnode(0, String("cde"));
	tmp->SetType(NT_REG);
	if (symboltable.Enter(tmp, idx) == STE_DUP)
		cout << "Dup! (should not happen)" << endl;
	else
		cout << "cde entered ok" << endl;

	tmp = new STnode(0, String("bcd"));
	tmp->SetType(NT_MOD);
	if (symboltable.Enter(tmp, idx) == STE_DUP)
		cout << "bcd Dup! (ok)" << endl;
	else
		cout << "bcd No dup, error!" << endl;

	tmp = new STnode(0, String("cde"));
	tmp->SetType(NT_REG);
	if (symboltable.Enter(tmp, idx) == STE_DUP)
		cout << "cde Dup! (ok)" << endl;
	else
		cout << "cde No dup, error!" << endl;

	tmp = new STnode(1, String("bcd"));
	tmp->SetType(NT_MOD);
	if (symboltable.Enter(tmp, idx) == STE_DUP)
		cout << "bcd scope 1 Dup! (error!)" << endl;
	else
		cout << "bcd scope 1 entered ok" << endl;

	idx = hash(String("abc"), 0);
	STnode *a = symboltable[idx];
	if (a == NULL)
		cout << idx << ':' << "abc not found (Not!)" << endl;
	else
		cout << idx << ':' << *a << endl;

	idx = hash(String("bcd"), 0);
	a = symboltable[idx];
	if (a == NULL)
		cout << idx << ':' << "bcd not found (Not!)" << endl;
	else
		cout << idx << ':' << *a << endl;

	idx = hash(String("cde"), 0);
	a = symboltable[idx];
	if (a == NULL)
		cout << idx << ':' << "cde not found (Not!)" << endl;
	else
		cout << idx << ':' << *a << endl;

	idx = hash(String("def"), 0);
	a = symboltable[idx];
	if (a == NULL)
		cout << idx << ':' << "def not found (OK!)" << endl;
	else
		cout << idx << ':' << *a << endl;

	idx = hash(String("abc123"), 0);
	cout << "idx = " << idx << endl;
	idx = rehash(idx,3);
	cout << "idx = " << idx << endl;

	cout << "sym:" << endl << symboltable << endl;

	return 0;	
	}
