/*
 * Verilog Behavioral Simulator
 * Copyright (C) 1995 Lay Hoon Tho, Jimen Ching
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Special Contributions:
 *
 * The authors of this software would like to thank the University of 
 * Hawaii, College of Engineering for the use of their computer 
 * facilities in the course of the development of this software.  Special 
 * thanks to Dr. Alex Quilici, who is the advisor for this project, and Dr. 
 * Michael Smith, who taught us how to use Verilog.  We would also like
 * to thank the College of Engineering for the knowledge we have gained
 * through their engineering curriculum.
 *
 * Authors:
 *	Lay Hoon Tho
 *		8, Jalan Setia 6 Chamek,
 *		Kluang, 86000 Johore,
 *		Malaysia
 *
 *	Jimen Ching
 *		2108 Citron St. Apt. #2
 *		Honolulu, HI 96826
 *		USA
 *		(jching@aloha.com)
 */
#include <iostream.h>
#include "List.h"
#include "Base.h"
#include "PExpr.h"
#include "PTypes.h"

int
main()
	{
	Number a(10UL);
	Range tmp(1,8);
	String b("abc");
	RangeId c(b, tmp);
	Lvalue d(c);
	QString e(b);
	Expression *expr;
	List<Expression *> lst;

	cout << "Lvalue: " << c << endl;
	expr = &a;
	lst += expr;
	cout << "Expr pointing to Number: " << *expr << endl;
	expr = &c;
	lst += expr;
	cout << "Expr pointing to RangeId: " << *expr << endl;
	expr = &e;
	lst += expr;
	cout << "Expr pointing to QString: " << *expr << endl;

	while (Data(lst, expr))
		cout << *expr << " ";
	cout << endl;

	RangeId rid(String("funcname"));
	List<RangeId *> ridlst;
	ridlst += new RangeId(String("varA"));
	ridlst += new RangeId(String("varb"));
	RegDecl rd(ridlst);
	TFDecl *tfd = &rd;
	List<TFDecl *> tfdlst;
	tfdlst += tfd;
	Stmts *st = new AssignStmt(d, a);
	Function func(rid, tfdlst, *st);
	delete st;
	cout << "Function: " << func << endl;
	return 0;
	}
