/*+-------------------------------------------------------------------------
	ecufkey.h -- AT XENIX/UNIX function key phrases
	wht@n4hgf.Mt-Park.GA.US
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:03-27-1992-16:21-wht@n4hgf-re-include protection for all .h files */
/*:07-25-1991-12:55-wht@n4hgf-ECU release 3.10 */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#ifndef _ecufkey_h
#define _ecufkey_h

/*
 * indices to key mapping tables
 *
 * these are close to being magic numbers - don't change w/o looking
 * at IKDE_to_XF in ecutty.c
 */
enum ikde_enum {
	IKDE_HOME,
	IKDE_END,
	IKDE_PGUP,
	IKDE_PGDN,
	IKDE_F1,
	IKDE_F2,
	IKDE_F3,
	IKDE_F4,
	IKDE_F5,
	IKDE_F6,
	IKDE_F7,
	IKDE_F8,
	IKDE_F9,
	IKDE_F10,
	IKDE_F11,
	IKDE_F12,
	IKDE_CUU,
	IKDE_CUD,
	IKDE_CUR,
	IKDE_CUL,
	IKDE_CU5,
	IKDE_INS,
	IKDE_BKTAB
};
#define IKDE_lastKey	IKDE_BKTAB
#define IKDE_InitStr	(IKDE_BKTAB + 1)	/* initialization string kludge */
#define KDE_COUNT		(IKDE_BKTAB + 2)

#define KDE_LOGICAL_MAX		12	/* max length of keystroke sequence */
#define KDE_OUTSTR_MAX		32	/* max length of output sequence */

/*
 * KDE input line types
*/
#define KDETYPE_NAME		1
#define KDETYPE_ENTRY		2
#define KDETYPE_COMMENT		3
#define KDETYPE_EOF			4

typedef struct kde
{
	int count;
	uchar ikde;
	char logical[KDE_LOGICAL_MAX];
	char str[KDE_OUTSTR_MAX];
}	KDE;

/* when a count is not a count but an action: */
#define KACT_COMMAND			-1
#define KACT_LOCAL_SHELL		-2
#define KACT_REDISPLAY			-3

typedef struct kdemap
{
	uchar xf;			/* extended function code (0x80+ from ttygetc()) */
	short ikde;			/* index into keyset */
	char *name;			/* ECU "formal" name for key */
	char *init;			/* key sends this string to port by default */
}	KDEMAP;

char *keyset_idstr();

#endif /* _ecufkey_h */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of ecufkey.h */
