/* #define DEFENSIVE */
/* #define ANSI_DEBUG */		/* debug ansi */
/* #define ANSI_DEBUG_2 */		/* debug ansi intensive output */
/* #define ANSI_DEBUG_3 */		/* debug ansi selected output */
/* #define ANSI_DEBUG_NOBUF */	/* unbufferred logging */
/* #define ANSI_DEBUG_LOGFILE	"/dev/tty2h" */
/* #define DEBUG_CURSOR */
#ifndef LIMIT_BELL
#define LIMIT_BELL
#endif
/*+-------------------------------------------------------------------------
	ecurcvr.c - rcvr process + ANSI filter + non-ANSI<->ANSI hoop jumping
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	accumulate_ansi_sequence(rchar)
	ansi_CNL()
	ansi_CPL()
	ansi_CUB()
	ansi_CUD()
	ansi_CUF()
	ansi_CUP()
	ansi_CUU()
	ansi_DCH()
	ansi_DL()
	ansi_DSR()
	ansi_ECH()
	ansi_ED()
	ansi_EL()
	ansi_HPA()
	ansi_ICH()
	ansi_IL()
	ansi_SD()
	ansi_SGR()
	ansi_SU()
	ansi_VPA()
	is_ansi_terminator(rchar)
	lgetc_rcvr()
	process_ansi_sequence()
	process_rcvd_char(rchar)
	rcvd_ESC()
	rcvr()
	rcvr_log_open()
	rcvrdisp(buf,buflen)
	rcvrdisp_actual()
	rcvrdisp_actual2()
	redisplay_rcvr_screen()
	saved_cursor_restore_cursor()
	saved_cursor_save_cursor()
	spaces(buf,buflen)
	spaces_trap(code,buf,buflen)

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:09-06-1992-13:29-wht@n4hgf-add receiver process buffered screen write */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:05-29-1992-13:28-wht@n4hgf-no banner - phone numbers are security risk */
/*:11-11-1991-14:25-wht@n4hgf-lzero_length_read_detected code */
/*:11-11-1991-12:45-wht@n4hgf-add LIMIT_BELL code */
/*:08-26-1991-16:39-wht@n4hgf2-SD was still hopelessly manic */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:07-05-1991-06:13-wht@n4hgf-SD was in baaaaadd shape */
/*:01-09-1991-22:31-wht@n4hgf-ISC port */
/*:12-26-1990-14:32-wht@n4hgf-use memset in spaces() */
/*:12-21-1990-21:06-wht@n4hgf-CUF and CUB set non-ansi cursor incorrectly */
/*:12-20-1990-16:27-wht@n4hgf-had SU and SD swapped */
/*:11-30-1990-18:39-wht@n4hgf-non-ansi console rcvr appears to be working */
/*:11-28-1990-14:13-wht@n4hgf-start non-ansi console support */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "ecukey.h"
#include <sys/ipc.h>
#include <sys/sem.h>

extern int errno;
extern char rcvr_log_file[];	/* if rcvr_log!= 0,log filename */
extern int rcvr_log;			/* rcvr log active if != 0 */
extern FILE *rcvr_log_fp;		/* rcvr log file */
extern int rcvr_log_raw;		/* if true, log all, else filter ctl chrs */
extern int rcvr_log_append;		/* if true, append, else scratch */
extern int rcvr_log_flusheach;	/* if true, flush log on each char */
extern int rcvr_log_gen_title;

extern uint tcap_LINES;	/* terminal line quantity - see ecutcap.c */
extern uint tcap_COLS;	/* terminal column quantity - see ecutcap.c */
extern uint LINESxCOLS;

static char esc = ESC;
#define MAX_ANSI_LEN	30	/* generous */
char ansibuf[MAX_ANSI_LEN];
char *ansi;
int ansilen = 0;
int in_ansi_accumulation = 0;

int saved_cursor_y;
int saved_cursor_x;

#define RCVR_RDQUAN		250
char lgetc_buf[RCVR_RDQUAN];
char *lgetc_ptr;
extern int lgetc_count;

uchar autorz_frame[] = { SUB, 'B', '0', '0' };

#ifdef ANSI_DEBUG
FILE *wfp = (FILE *)0;
#endif

uchar non_multiscreen_hi_map[128] = {
/*80*/	'c','u','e','a','a','a','a','c', /* the main purpose of this ... */
/*88*/	'e','e','e','i','i','i','a','a', /* ... is to map ruling ... */
/*90*/	'e','e','a','a','a','o','u','u', /* ... characters, but as ...*/
/*98*/	'y','o','u','X','#','Y','P','f', /* ... a side effect, also map ... */
/*A0*/	'a','i','o','u','n','n','a','o', /* ... others to reasonable, ... */
/*A8*/	'?','-','-','%','%','|','<','>', /* ... near, amusing, or random ... */
/*B0*/	'#','#','#','|','+','+','+','.', /* ... printing characters as well */
/*B8*/	'.','+','|','.','\'','\'','\'','.',
/*C0*/	'`','+','+','+','-','+','+','+',
/*C8*/	'`','.','+','+','+','=','+','+',
/*D0*/	'+','+','+','`','`','.','.','+',
/*D8*/	'+','\'','.','#','_','|','|','-',
/*E0*/	'a','b','F','T','E','o','u','t',
/*E8*/	'I','0','O','o','o','o','e','n',
/*F0*/	'=','+','>','<','f','j','%','=',
/*F8*/	'o','.','.','V','n','2','*',' '
};

/*
 * if != 0, allow xmtr use of rcvrdisp_actual2() function to buffer,
 * if 0, flush buffer whenever the function is called
 */
int rcvrdisp_actual2_xmtr_buffer = 0;

/*+-------------------------------------------------------------------------
	rcvrdisp_p() - lock rcvrdisp mechanism
--------------------------------------------------------------------------*/
#ifdef RCVRDISP_PV
void
rcvrdisp_p()
{
	register int retn;
	struct sembuf sembuf;

	sembuf.sem_num = 0;
	sembuf.sem_op = -1;
	sembuf.sem_flg = 0;

	while(1)
	{
		if(((retn = semop(shm->rcvrdisp_semid,&sembuf,1)) >= 0) ||
			(errno != EINTR))
		{
			break;
		}
	}

	if((retn < 0) && (errno != EINVAL))
	{
		extern char lopen_err_str[];
		strcpy(lopen_err_str,"rcvrdisp_p failed: SysV IPC error");
		termecu(TERMECU_IPC_ERROR);
	}

}	/* end of rcvrdisp_p */
#endif /*  RCVRDISP_PV */

/*+-------------------------------------------------------------------------
	rcvrdisp_v() - unlock rcvrdisp mechanism
--------------------------------------------------------------------------*/
#ifdef RCVRDISP_PV
void
rcvrdisp_v()
{
	register int retn;
	struct sembuf sembuf;

	sembuf.sem_num = 0;
	sembuf.sem_op = 1;
	sembuf.sem_flg = 0;

	while(1)
	{
		if(((retn = semop(shm->rcvrdisp_semid,&sembuf,1)) >= 0) ||
			(errno != EINTR))
		{
			break;
		}
	}

	if((retn < 0) && (errno != EINVAL))
	{
		extern char lopen_err_str[];
		strcpy(lopen_err_str,"rcvrdisp_v failed: SysV IPC error");
		termecu(TERMECU_IPC_ERROR);
	}
}	/* end of rcvrdisp_v */
#endif /*  RCVRDISP_PV */

/*+-------------------------------------------------------------------------
	rcvrdisp_actual() - actual write to screen
--------------------------------------------------------------------------*/
void
rcvrdisp_actual()
{
#ifdef RCVRDISP_PV
	rcvrdisp_p();
#endif /*  RCVRDISP_PV */
	if(shm->rcvrdisp_count)
		write(TTYOUT,shm->rcvrdisp_buffer,shm->rcvrdisp_count);
	shm->rcvrdisp_ptr = shm->rcvrdisp_buffer;
	shm->rcvrdisp_count = 0;
#ifdef RCVRDISP_PV
	rcvrdisp_v();
#endif /*  RCVRDISP_PV */

}	/* end of rcvrdisp_actual */

/*+-------------------------------------------------------------------------
	rcvrdisp_actual2() - for tcap, flush only if not receiver
--------------------------------------------------------------------------*/
void
rcvrdisp_actual2()
{
	if(rcvrdisp_actual2_xmtr_buffer || (getpid() == rcvr_pid))
		return;
#ifdef RCVRDISP_PV
	rcvrdisp_p();
#endif /*  RCVRDISP_PV */
	if(shm->rcvrdisp_count)
		write(TTYOUT,shm->rcvrdisp_buffer,shm->rcvrdisp_count);
	shm->rcvrdisp_ptr = shm->rcvrdisp_buffer;
	shm->rcvrdisp_count = 0;
#ifdef RCVRDISP_PV
	rcvrdisp_v();
#endif /*  RCVRDISP_PV */

}	/* end of rcvrdisp_actual2 */

/*+-------------------------------------------------------------------------
	rcvrdisp(buf,buflen) - logical write to screen
--------------------------------------------------------------------------*/
void
rcvrdisp(buf,buflen)
char *buf;
int buflen;
{

	if((buflen + shm->rcvrdisp_count) > sizeof(shm->rcvrdisp_buffer))
		rcvrdisp_actual();
	if((buflen + shm->rcvrdisp_count) > sizeof(shm->rcvrdisp_buffer))
	{
		write(TTYOUT,buf,buflen);
		return;
	}
#ifdef RCVRDISP_PV
	rcvrdisp_p();
#endif /*  RCVRDISP_PV */
	memcpy(shm->rcvrdisp_ptr,buf,buflen);
	shm->rcvrdisp_ptr += buflen;
	shm->rcvrdisp_count += buflen;
#ifdef RCVRDISP_PV
	rcvrdisp_v();
#endif /*  RCVRDISP_PV */

}	/* end of rcvrdisp */

/*+-------------------------------------------------------------------------
	redisplay_rcvr_screen() - redisplay logical receiver screen
As of writing, this function is called only by the XMTR process
--------------------------------------------------------------------------*/
void
redisplay_rcvr_screen()
{
	register uint y;
	extern int tty_not_char_special;


	if(tty_not_char_special)
		return;

	setcolor(colors_current);
	tcap_stand_end();
	for(y = 0; y < tcap_LINES; y++)
	{
		tcap_cursor(y,0);
		fwrite(&shm->screen[y][0],
			((y != tcap_LINES - 1) ? tcap_COLS : tcap_COLS - 1),1,se);
	}
	tcap_eeol();
	tcap_cursor(shm->cursor_y,shm->cursor_x);

}	/* end of redisplay_rcvr_screen */

#ifdef DEBUG_CURSOR
void
spaces_trap(code,buf,buflen)
int code;
register uchar *buf;
register uint buflen;
{
	char *xyz = (char *)0x90000000;
	ff(se,"rcvr 'spaces trap' code %d: cursor x,y=%d,%d\r\n",
		code,
		shm->cursor_y,shm->cursor_x);
	ff(se,"buf=%08lx len=%08lx offs=%08lx\r\n",buf,buflen,
		(ulong)buf - (ulong)shm->screen);
	*xyz = 0;
	abort();
}
#endif

/*+-------------------------------------------------------------------------
	spaces(buf,buflen) - fill with spaces
--------------------------------------------------------------------------*/
void
spaces(buf,buflen)
register uchar *buf;
uint buflen;
{
#ifdef DEBUG_CURSOR
	if((ulong)buf > (((ulong)shm->screen) + LINESxCOLS))
		spaces_trap(1,buf,buflen);
	if((ulong)buf < (ulong)shm->screen)
		spaces_trap(2,buf,buflen);
	if((ulong)(buf + buflen) > (((ulong)shm->screen) + LINESxCOLS))
		spaces_trap(3,buf,buflen);
	if((ulong)(buf + buflen) < (ulong)shm->screen)
		spaces_trap(4,buf,buflen);
#endif

	if(!buflen)
		return;

#ifdef DEFENSIVE
	if((ulong)buf < (ulong)shm->screen)
		return;
	if((ulong)(buf + buflen) > (((ulong)shm->screen) + LINESxCOLS))
		return;
#endif

	memset(buf,SPACE,buflen);

}	/* end of spaces */

/*+-------------------------------------------------------------------------
	lgetc_rcvr() - rcvr version of get char from line
--------------------------------------------------------------------------*/
int
lgetc_rcvr()
{
	extern int errno;

	if(!lgetc_count)
	{
		rcvrdisp_actual();
		while(lgetc_count <= 0)
		{
			errno = 0;
			if((lgetc_count =
				read(shm->Liofd,lgetc_buf,RCVR_RDQUAN)) < 0)
			{
				if(errno == EINTR)	/* if signal interrupted, ... */
					continue;		/* ... read again */
				termecu(TERMECU_LINE_READ_ERROR);
			}
			if(!lgetc_count)
			{
				lzero_length_read_detected(); /* maybe terminate program ... */
				continue;					/* ... but if not, read again */
			}
		}
		shm->rcvd_chars += lgetc_count;
		shm->rcvd_chars_this_connect += lgetc_count;
		lgetc_ptr = lgetc_buf;
	}

	lgetc_count--;

	if(shm->Lparity)
		return(*lgetc_ptr++ & 0x7F);
	else
		return(*lgetc_ptr++);

}	/* end of lgetc_rcvr */

/*+-------------------------------------------------------------------------
	ansi_SGR() - Set Graphics Rendition

The DOS ANSI world expects to be able to be able to chain 0,1 and
3x,4x params together with semicolons.

  Supported modifiers for non-ansi terminals
  0       normal
  1       bold
  4       underscore
  5       blink
  7       reverse video
--------------------------------------------------------------------------*/
void
ansi_SGR()
{
	register itmp;
	register char *cptr;
	char SGRstr[MAX_ANSI_LEN];
	char *token;
	char *str_token();

	if(!tty_is_multiscreen)
	{
		ansibuf[ansilen - 1] = 0;	/* get rid of 'm' */
		cptr = ansibuf + 1;			/* get rid of '[' */
		if(!strlen(cptr))
			goto SGR_0;
		while(token = str_token(cptr,";"))
		{
			cptr = (char *)0;	/* further calls to str_token need NULL */
			switch(atoi(token))
			{
				default:
				case 0:		/* normal */
SGR_0:
					tcap_stand_end();
					tcap_blink_off();
					tcap_underscore_off();
					tcap_bold_off();
					break;
				case 1:		/* bold */
					tcap_bold_on();
					break;
				case 4:		/* underscore */
					tcap_underscore_on();
					break;
				case 5:		/* blink */
					tcap_blink_on();
					break;
				case 7:		/* reverse video */
					tcap_stand_out();
					break;
			}
		}
		return;
	}

	if(ansilen <= 3)	/* 'ESC[<0-9>m' and 'ESC[m' - quickly handled */
	{
		rcvrdisp(&esc,1);
		rcvrdisp(ansibuf,ansilen);
		return;
	}

/* check XENIX 'ESC[<2,3,7>m' extensions */
	switch(itmp = atoi(ansibuf + 1))
	{
		case 7: /* XENIX 'ESC[7;<0-15>;<0-15>m' set fore/background color */
			itmp = atoi(ansibuf + 3);	/* second parameter */
			if(itmp > 15)				/* not XENIX extension */
				break;
			/* fall through */
		case 2:	/* XENIX 'ESC[2;<0-15>;<0-15>m' set fore/background color */
		case 3:	/* XENIX 'ESC[3;<0-1>m' color only set/clear blink */
			rcvrdisp(&esc,1);
			rcvrdisp(ansibuf,ansilen);
			return;
		default:
			break;
	}

/* not XENIX extension */
	ansibuf[ansilen - 1] = 0;	/* get rid of 'm' */
	cptr = ansibuf + 1;			/* get rid of '[' */

	while(token = str_token(cptr,";"))
	{
		cptr = (char *)0;	/* further calls to str_token need NULL */
		sprintf(SGRstr,"\033[%sm",token);
		rcvrdisp(SGRstr,strlen(SGRstr));
	}

}	/* end of ansi_SGR */

/*+-------------------------------------------------------------------------
	ansi_CUP() - cursor position (also HVP horiz/vertical position)
--------------------------------------------------------------------------*/
void
ansi_CUP()
{
	register uint param_count = 0;
	char ansicopy[MAX_ANSI_LEN];
	register char *cptr = ansicopy;
	register char *token;
	char *str_token();

	strcpy(cptr,ansibuf + 1);
	*(cptr + ansilen - 2) = 0;

	while(token = str_token(cptr,";"))
	{
		cptr = (char *)0;	/* further calls to str_token need NULL */
		switch(++param_count)
		{
			case 1:	shm->cursor_y = atoi(token) - 1; break;
			case 2:	shm->cursor_x = atoi(token) - 1; break;
		}
	}
	switch(param_count)
	{
		case 0:
			shm->cursor_y = 0;
		case 1:
			shm->cursor_x = 0;
	}
	if(shm->cursor_x >= tcap_COLS)
		shm->cursor_x = 0;
	if(shm->cursor_y >= tcap_LINES)
		shm->cursor_y = 0;

	if(!tty_is_multiscreen)
		tcap_cursor(shm->cursor_y,shm->cursor_x);

}	/* end of ansi_CUP */

/*+-------------------------------------------------------------------------
	ansi_CUU() - cursor up
--------------------------------------------------------------------------*/
void
ansi_CUU()
{
	register uint count;
	register uint y;

	if(ansilen == 2)		/* no param */
		count = 1;
	else
		count = atoi(ansibuf + 1);

	y = shm->cursor_y - count;
	if(y >= tcap_LINES)	/* unsigned comparison */
		y = 0;

	if(y != shm->cursor_y)
	{
		shm->cursor_y = y;
		if(!tty_is_multiscreen)
			tcap_cursor(shm->cursor_y,shm->cursor_x);
	}

}	/* end of ansi_CUU */

/*+-------------------------------------------------------------------------
	ansi_CUD() - cursor down (also VPR vertical position relative)
--------------------------------------------------------------------------*/
void
ansi_CUD()
{
	register uint count;
	register uint y;

	if(ansilen == 2)		/* no param */
		count = 1;
	else
		count = atoi(ansibuf + 1);

	y = shm->cursor_y + count;
	if(y >= tcap_LINES)
		y = tcap_LINES - 1;

	if(y != shm->cursor_y)
	{
		shm->cursor_y = y;
		if(!tty_is_multiscreen)
			tcap_cursor(shm->cursor_y,shm->cursor_x);
	}

}	/* end of ansi_CUD */

/*+-------------------------------------------------------------------------
	ansi_CUF() - cursor forward (also HPR horizontal position relative)
--------------------------------------------------------------------------*/
void
ansi_CUF()
{
	register uint count;
	register uint x;

	if(ansilen == 2)		/* no param */
		count = 1;
	else
		count = atoi(ansibuf + 1);

	x = shm->cursor_x + count;
	if(x >= tcap_COLS)
		x = tcap_COLS - 1;

	if(x != shm->cursor_x)
	{
		shm->cursor_x = x;
		if(!tty_is_multiscreen)
			tcap_cursor(shm->cursor_y,shm->cursor_x);
	}

}	/* end of ansi_CUF */

/*+-------------------------------------------------------------------------
	ansi_CUB() - cursor forward
--------------------------------------------------------------------------*/
void
ansi_CUB()
{
	register uint count;
	register uint x;

	if(ansilen == 2)		/* no param */
		count = 1;
	else
		count = atoi(ansibuf + 1);

	x = shm->cursor_x - count;
	if(x >= tcap_COLS)	/* unsigned comparison */
		x = 0;

	if(x != shm->cursor_x)
	{
		shm->cursor_x = x;
		if(!tty_is_multiscreen)
			tcap_cursor(shm->cursor_y,shm->cursor_x);
	}

}	/* end of ansi_CUB */

/*+-------------------------------------------------------------------------
	ansi_DSR() - device status report
--------------------------------------------------------------------------*/
void
ansi_DSR()
{
	char response[MAX_ANSI_LEN];

	sprintf(response,"\033[%d;%dR",shm->cursor_y + 1,shm->cursor_x + 1);
	write(shm->Liofd,response,strlen(response));

}	/* end of ansi_DSR */

/*+-------------------------------------------------------------------------
	ansi_ED() - erase in display
--------------------------------------------------------------------------*/
void
ansi_ED()
{
	register uint param;
	int y;

	if(ansilen == 2)		/* no param */
		param = 0;
	else
		param = atoi(ansibuf + 1);

	switch(param)
	{
		case 0:	/* erase to end of display */
			spaces(&shm->screen[shm->cursor_y][shm->cursor_x],
				LINESxCOLS - ((shm->cursor_y * tcap_COLS) + shm->cursor_x));
			if(!tty_is_multiscreen)
				tcap_eeod();
			break;
		case 1:	/* erase from beginning of display */
			spaces((char *)shm->screen,(shm->cursor_y * tcap_COLS) +
				shm->cursor_x);
			if(!tty_is_multiscreen)
			{
				for(y = 0; y < shm->cursor_y - 1; y++)
				{
					tcap_cursor(y,0);
					tcap_eeol();
				}
				if(shm->cursor_x)
				{
					tcap_cursor(shm->cursor_y,0);
					tcap_clear_area_char(shm->cursor_x,' ');
				}
				else
					tcap_cursor(shm->cursor_y,shm->cursor_x);
			}
			break;
		case 2:	/* clear display */
			shm->cursor_y = 0;
			shm->cursor_x = 0;
			spaces((char *)shm->screen,LINESxCOLS);
			if(!tty_is_multiscreen)
			{
				tcap_clear_screen();
				tcap_cursor(shm->cursor_y,shm->cursor_x);
			}
			break;
	}

}	/* end of ansi_ED */

/*+-------------------------------------------------------------------------
	ansi_EL() - erase in line
--------------------------------------------------------------------------*/
void
ansi_EL()
{
	register uint param;
	char cr = CRET;

	if(ansilen == 2)		/* no param */
		param = 0;
	else
		param = atoi(ansibuf + 1);

	switch(param)
	{
		case 2:	/* clear line */
			shm->cursor_x = 0;
			if(!tty_is_multiscreen)
				rcvrdisp(&cr,1);
			/* fall thru */
		case 0:	/* erase to end of line */
			spaces(&shm->screen[shm->cursor_y][shm->cursor_x],
				tcap_COLS - shm->cursor_x);
			if(!tty_is_multiscreen)
				tcap_eeol();
			break;
		case 1:	/* erase from beginning of line */
			spaces(&shm->screen[shm->cursor_y][0],shm->cursor_x);
			if(!tty_is_multiscreen && shm->cursor_x)
			{
				rcvrdisp(&cr,1);
				tcap_clear_area_char(shm->cursor_x,' ');
			}
			break;
	}

}	/* end of ansi_EL */

/*+-------------------------------------------------------------------------
	ansi_ECH() - erase characters
--------------------------------------------------------------------------*/
void
ansi_ECH()
{
	register uint param;
	register uint screen_pos;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if((shm->cursor_x + param) >= tcap_COLS)
		return;

	screen_pos = (shm->cursor_y * tcap_COLS) + shm->cursor_x;
	mem_cpy((char *)shm->screen + screen_pos,
	       (char *)shm->screen + screen_pos + param,param);
	spaces((char *)shm->screen + ((shm->cursor_y + 1) * tcap_COLS) -
				param,param);

	if(!tty_is_multiscreen)
		tcap_delete_chars(param);

}	/* end of ansi_ECH */

/*+-------------------------------------------------------------------------
	ansi_SU() - scroll up (new blank lines at the bottom)
--------------------------------------------------------------------------*/
void
ansi_SU()
{
	register uint param;
	register uint count;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if(param > tcap_LINES)
		param = tcap_LINES;
	if(!param)
		return;

#ifdef ANSI_DEBUG_3
	if(wfp)
		fprintf(wfp,"SU: param=%u y,x=%d,%d\n",param,
			shm->cursor_y,shm->cursor_x);
#endif

	count = tcap_COLS * param;
	mem_cpy((char *)shm->screen,(char *)shm->screen + count,
		LINESxCOLS - count);
	spaces((char *)shm->screen + LINESxCOLS - count,count);

	if(!tty_is_multiscreen)
	{
		tcap_cursor(tcap_LINES - 1,0);
		while(param--)
			ff(se,"\r\n");
		tcap_cursor(shm->cursor_y,shm->cursor_x);
	}

}	/* end of ansi_SU */

/*+-------------------------------------------------------------------------
	ansi_SD() - scroll down (new blank lines at the top)
--------------------------------------------------------------------------*/
void
ansi_SD()
{
	register uint param;
	register uint count;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if(param > tcap_LINES)
		param = tcap_LINES;
	if(!param)
		return;

#ifdef ANSI_DEBUG_3
	if(wfp)
		fprintf(wfp,"SD: param=%u y,x=%d,%d\n",param,
			shm->cursor_y,shm->cursor_x);
#endif

	count = tcap_COLS * param;
	mem_cpy((char *)shm->screen,(char *)shm->screen + count,
		LINESxCOLS - count);
	spaces((char *)shm->screen + LINESxCOLS - count,count);

	if(!tty_is_multiscreen)
	{
		tcap_cursor(0,0);
		tcap_insert_lines(param);
		tcap_cursor(shm->cursor_y,shm->cursor_x);
	}

}	/* end of ansi_SD */

/*+-------------------------------------------------------------------------
	ansi_HPA() - horizontal position absolute
--------------------------------------------------------------------------*/
void
ansi_HPA()
{
	register uint param;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if(param >= tcap_LINES)
		return;

	if((unsigned)(shm->cursor_x = param) >= (unsigned)tcap_COLS)
		shm->cursor_x = tcap_COLS - 1;

	if(!tty_is_multiscreen)
		tcap_cursor(shm->cursor_y,shm->cursor_x);

}	/* end of ansi_HPA */

/*+-------------------------------------------------------------------------
	ansi_VPA() - vertical position absolute
--------------------------------------------------------------------------*/
void
ansi_VPA()
{
	register uint param;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if(param >= tcap_COLS)
		return;

	if((unsigned)(shm->cursor_y = param) >= (unsigned)tcap_LINES)
		shm->cursor_y = tcap_LINES - 1;

	if(!tty_is_multiscreen)
		tcap_cursor(shm->cursor_y,shm->cursor_x);

}	/* end of ansi_VPA */

/*+-------------------------------------------------------------------------
	ansi_IL() - insert lines
--------------------------------------------------------------------------*/
void
ansi_IL()
{
	register uint param;
	register uint count;
	register uint screen_pos;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if((shm->cursor_y + param) >= tcap_LINES)
		return;

	count = tcap_COLS * param;
	screen_pos = shm->cursor_y * tcap_COLS;
	mem_cpy((char *)shm->screen + screen_pos + count,
	       (char *)shm->screen + screen_pos,
		   LINESxCOLS - screen_pos - count);
	spaces((char *)shm->screen + screen_pos,count);

	if(!tty_is_multiscreen)
		tcap_insert_lines(param);

}	/* end of ansi_IL */

/*+-------------------------------------------------------------------------
	ansi_ICH() - insert characters
--------------------------------------------------------------------------*/
void
ansi_ICH()
{
	register uint param;
	register uint count;
	register uint screen_pos;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if(param > tcap_COLS - shm->cursor_x)
		param = tcap_COLS - shm->cursor_x;

	if(!param)
		return;

	screen_pos = (shm->cursor_y * tcap_COLS) + shm->cursor_x;
	count = tcap_COLS - shm->cursor_x - param;
	mem_cpy((char *)shm->screen + screen_pos + param,
	       (char *)shm->screen + screen_pos,count);
	spaces((char *)shm->screen + screen_pos,param);

	if(!tty_is_multiscreen)
		tcap_insert_chars(param);

}	/* end of ansi_ICH */

/*+-------------------------------------------------------------------------
	ansi_DL() - delete lines
--------------------------------------------------------------------------*/
void
ansi_DL()
{
	register uint param;
	register uint count;
	register uint screen_pos;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if(param > (tcap_LINES - shm->cursor_y))
		param = tcap_LINES - shm->cursor_y;

	if(!param)
		return;

	count = tcap_COLS * param;
	screen_pos = shm->cursor_y * tcap_COLS;
	mem_cpy((char *)shm->screen + screen_pos,
		   (char *)shm->screen + screen_pos + count,
			LINESxCOLS - screen_pos - count);
	spaces((char *)shm->screen + LINESxCOLS - count,count);

	if(!tty_is_multiscreen)
		tcap_delete_lines(param);

}	/* end of ansi_DL */

/*+-------------------------------------------------------------------------
	ansi_DCH() - delete characters
--------------------------------------------------------------------------*/
void
ansi_DCH()
{
	register uint param;
	register uint count;
	register uint screen_pos;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if(param > tcap_COLS - shm->cursor_x)
		param = tcap_COLS - shm->cursor_x;

	if(!param)
		return;

	screen_pos = (shm->cursor_y * tcap_COLS) + shm->cursor_x;
	count = tcap_COLS - shm->cursor_x - param;
	mem_cpy((char *)shm->screen + screen_pos,
	        (char *)shm->screen + screen_pos + param,count);
	screen_pos = ((shm->cursor_y + 1) * tcap_COLS) - param;
	spaces((char *)shm->screen + screen_pos,param);

	if(!tty_is_multiscreen)
		tcap_delete_chars(param);

}	/* end of ansi_DCH */

/*+-------------------------------------------------------------------------
	ansi_CPL() - cursor to previous line
--------------------------------------------------------------------------*/
void
ansi_CPL()
{
	register uint param;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if((shm->cursor_y -= param) >= tcap_LINES)	/* unsigned comparison */
		shm->cursor_y = 0;
	shm->cursor_x = 0;

	if(!tty_is_multiscreen)
		tcap_cursor(shm->cursor_y,shm->cursor_x);

}	/* end of ansi_CPL */

/*+-------------------------------------------------------------------------
	ansi_CNL() - cursor to next line
--------------------------------------------------------------------------*/
void
ansi_CNL()
{
	register uint param;

	if(ansilen == 2)		/* no param */
		param = 1;
	else
		param = atoi(ansibuf + 1);

	if((shm->cursor_y += param) >= tcap_LINES)
		shm->cursor_y = tcap_LINES - 1;
	shm->cursor_x = 0;

	if(!tty_is_multiscreen)
		tcap_cursor(shm->cursor_y,shm->cursor_x);

}	/* end of ansi_CNL */

/*+-------------------------------------------------------------------------
	saved_cursor_save_cursor() - nice but unfortunate IBM extension

I can't find this used anywhere but in the DOS world.  Supporting this
pair of sequences is what started this whole complex mess.
--------------------------------------------------------------------------*/
void
saved_cursor_save_cursor()
{
	saved_cursor_y = shm->cursor_y;
	saved_cursor_x = shm->cursor_x;
}	/* end of saved_cursor_save_cursor */

/*+-------------------------------------------------------------------------
	saved_cursor_restore_cursor() - nice but unfortunate IBM extension

I can't find this used anywhere but in the DOS world.  Supporting this
pair of sequences is what started this whole complex mess.
--------------------------------------------------------------------------*/
void
saved_cursor_restore_cursor()
{
	shm->cursor_y = saved_cursor_y;
	shm->cursor_x = saved_cursor_x;
	tcap_cursor(shm->cursor_y,shm->cursor_x);
}	/* end of saved_cursor_restore_cursor */

/*+-------------------------------------------------------------------------
	rcvd_ESC() - ESC seen-prepare to accumulate ansi sequence
--------------------------------------------------------------------------*/
void
rcvd_ESC()
{
#ifdef ANSI_DEBUG
	if(wfp)
		fprintf(wfp,"ESC ");
#endif

	ansi = ansibuf;
	ansilen = 0;
	in_ansi_accumulation = 1;

}	/* end of rcvd_ESC */

/*+-------------------------------------------------------------------------
	is_ansi_terminator(rchar) - is character terminator for ansi sequence?
--------------------------------------------------------------------------*/
int
is_ansi_terminator(rchar)
register uint rchar;
{
	return(isalpha(rchar) || (rchar == '@'));
}	/* end of is_ansi_terminator */

/*+-------------------------------------------------------------------------
	accumulate_ansi_sequence(rchar)
--------------------------------------------------------------------------*/
void
accumulate_ansi_sequence(rchar)
uint rchar;
{
	if(ansilen == (MAX_ANSI_LEN - 2))
	{
		in_ansi_accumulation = 0;
		return;
	}

#ifdef ANSI_DEBUG_2
	if(wfp)
	{
		fprintf(wfp,"\naas: %02x %c ansilen=%d",
			rchar,(rchar & 0x7F < SPACE) ? '.' : (rchar & 0x7F),ansilen);
	}
#endif

	*ansi++ = (uchar)rchar;
	*ansi   = 0;
	ansilen++;

}	/* end of accumulate_ansi_sequence */

/*+-------------------------------------------------------------------------
	process_ansi_sequence() - a full ansi sequence is to be decoded
--------------------------------------------------------------------------*/
void
process_ansi_sequence()
{
	register itmp;

#ifdef ANSI_DEBUG
	if(wfp)
		fprintf(wfp,"\npas: len=%d '%s' y,x=%d,%d\n",ansilen,ansibuf,
			shm->cursor_y,shm->cursor_x);
#endif

	if(!in_ansi_accumulation)
		return;
	in_ansi_accumulation = 0;

	itmp = 1;		/* assume write needed */
	if((ansilen > 1) && (ansibuf[1] == '='))
		;
	else switch(ansibuf[ansilen - 1])
	{
		case '@': ansi_ICH(); break;
		case 'A': ansi_CUU(); break;
		case 'B': ansi_CUD(); break;
		case 'C': ansi_CUF(); break;
		case 'D': ansi_CUB(); break;
		case 'E': ansi_CNL(); break;
		case 'F': ansi_CPL(); break;
		case 'H': ansi_CUP(); break;
		case 'J': ansi_ED(); break;
		case 'K': ansi_EL(); break;
		case 'L': ansi_IL(); break;
		case 'M': ansi_DL(); break;
		case 'P': ansi_DCH(); break;
		case 'S': ansi_SU(); break;
		case 'T': ansi_SD(); break;
		case 'X': ansi_ECH(); break;
		case '`': ansi_HPA(); break;
		case 'a': ansi_CUF(); break; /* HPR */
		case 'd': ansi_VPA(); break;
		case 'e': ansi_CUD(); break; /* VPR */
		case 'f': ansi_CUP(); break; /* HVP */
		case 'm': ansi_SGR(); itmp = 0; break;
		case 'n': ansi_DSR(); itmp = 0; break;
		case 's': saved_cursor_save_cursor(); itmp = 0; break;
		case 'u': saved_cursor_restore_cursor(); itmp = 0; break;
#ifdef FUTURES
		case 'h': ansi_SM(); break;	/* Set Mode: SCO: lock keyboard
									 *           MSDOS: host of shit */
		case 'i': ansi_MC(); break;	/* Media Copy: send screen to line */
		case 'l': ansi_RM(); break;	/* Reset Mode: SCO: unlock keyboard
									 *             MSDOS: host of shit */
#endif /* FUTURES */
		default:
			break;
	}

/* if proper ansi console and indicated, write the buffer to the screen */
	if(tty_is_multiscreen && itmp)
	{
		rcvrdisp(&esc,1);
		rcvrdisp(ansibuf,ansilen);
	}

#ifdef ANSI_DEBUG
	if(wfp)
		fprintf(wfp,"pas: new cursor y,x=%d,%d\n",shm->cursor_y,shm->cursor_x);
#endif
}	/* end of process_ansi_sequence */

/*+-------------------------------------------------------------------------
	rcvr_log_open()
--------------------------------------------------------------------------*/
void
rcvr_log_open()
{

	if(rcvr_log)		/* if xmtr set us up for logging */
	{
		rcvr_log_fp = fopen(rcvr_log_file,rcvr_log_append ? "a" : "w");
		rcvr_log_append = 1;	/* until next %log -s */
		if(!rcvr_log_fp)
		{
			ff(se,"ecu RCVR: Could not open log file: %s\r\n",rcvr_log_file);
			ff(se,"recording aborted.\r\n");
			rcvr_log = 0;
		}
		else if(!rcvr_log_raw && rcvr_log_gen_title)
		{
#if 0 /* decommitted - security risk */
			char tstr[80];
			get_tod(2,tstr);
			fprintf(rcvr_log_fp,"\n====> %s (%s, %s, %s) %s\n\n",
				shm->Lrname,shm->Llogical,
				shm->Ldescr,(shm->Ltelno[0]) ? shm->Ltelno : "NONE",tstr);
#endif
		}
		rcvr_log_gen_title = 0;
	}
}	/* end of rcvr_log_open */

/*+-------------------------------------------------------------------------
	process_rcvd_char(rchar) - process a received character

Return 0 if char should be written to console, 1 otherwise
--------------------------------------------------------------------------*/
int
process_rcvd_char(rchar)
register uint rchar;
{
	register itmp;
#ifdef LIMIT_BELL
	long now;
	static long last_bell_time = -1L;
#endif

	/*
	 * automatic ZMODEM frame detection (expensive CPU burners for lazy folks)
	 */
	if(shm->autorz)
	{
		if((uchar)rchar == autorz_frame[shm->autorz_pos])
		{
			itmp = shm->autorz_pos;	/* copy to register trying to be quick */
			if(++itmp == sizeof(autorz_frame))
			{
				if(lgetc_count)
				{
					rcvrdisp(lgetc_ptr,lgetc_count);
					lgetc_count = 0;
				}
				shmr_notify_zmodem_frame();
				pause();		/* wait for death */
				itmp = 0;		/* in case something starts us up */
			}
			shm->autorz_pos = itmp;
			return(!itmp);	/* don't try to print ^X */
		}
		else
			shm->autorz_pos = 0;
	}

	/*
	 * BEL and alarm-on-incoming-data processing
	 */
	if(shm->bell_notify_state == 2)
	{
		shm->bell_notify_state = 1;
		bell_notify(XBELL_3T);
	}
	else if(rchar == BEL)
	{
#ifdef LIMIT_BELL
		time(&now);
		if((now - last_bell_time) < 2L)
			return(1);
		last_bell_time = now;
#endif
		bell_notify(XBELL_ATTENTION);
		return(0);
	}

	/*
	 * video control sequences
	 */
	if(rchar == ESC)
	{
		rcvd_ESC();
		return(1);
	}
	else if(in_ansi_accumulation)
	{
		accumulate_ansi_sequence(rchar);
		if(is_ansi_terminator(rchar))
			process_ansi_sequence();
		return(1);
	}

	/*
	 * the bread and butter of the receiver:
	 * print printable characters and obey formatting characters
	 */
	if(rchar < SPACE)
	{
		switch(rchar)
		{
			case CTL_L:
				spaces((char *)shm->screen,LINESxCOLS);
				shm->cursor_y = 0;
				shm->cursor_x = 0;
				break;

			case BS:
			case DEL:
				if(shm->cursor_x)
					shm->cursor_x--;
				break;

			case NL:
				if(shm->cursor_y != tcap_LINES - 1)
					shm->cursor_y++;
				else
				{
					mem_cpy((char *)shm->screen,(char *)shm->screen + tcap_COLS,
						LINESxCOLS - tcap_COLS);
					spaces(&shm->screen[shm->cursor_y][0],tcap_COLS);
				}
				break;

			case CRET:
				shm->cursor_x = 0;
				break;

			case TAB:
				itmp = 8 - (shm->cursor_x % 8);
				shm->cursor_x += itmp;
				if(shm->cursor_x >= tcap_COLS)
				{
					shm->cursor_x = 0;
					if(++shm->cursor_y >= tcap_LINES)
						shm->cursor_y = tcap_LINES - 1;
				}
				spaces(&shm->screen[shm->cursor_y][shm->cursor_x],itmp);
				break;

#ifdef TANDEM_ENQ_ACK	/* for my friend John Dashner at Tandem */
			case ENQ:
				lputc(ACK);
				return(0);
#endif

		}
	}
	else
	{
		shm->screen[shm->cursor_y][shm->cursor_x++] = (uchar)rchar;
		if(shm->cursor_x >= tcap_COLS)
		{
			shm->cursor_x = 0;
			if(shm->cursor_y != tcap_LINES - 1)
				shm->cursor_y++;
			else
			{
				mem_cpy((char *)shm->screen,(char *)shm->screen + tcap_COLS,
					LINESxCOLS - tcap_COLS);
				spaces(&shm->screen[shm->cursor_y][shm->cursor_x],tcap_COLS);
			}
		}
	}

#ifdef ANSI_DEBUG_2
	if(wfp)
	{
		if((rchar & 0x7F) == NL)
			fputs("\n",wfp);
		else
			fputc(((rchar & 0x7F) < SPACE) ? '.' : (rchar & 0x7F),wfp);
	}
#endif

	/*
	 * receiver logging
	 */
	if(rcvr_log && rcvr_log_fp)
	{
		/* if raw mode or character not excluded from "cooked" logging */
		if(rcvr_log_raw || ((rchar >= SPACE) && (rchar <= '~')) ||
			 (rchar == NL) || (rchar == TAB))
		{
			LOGPUTC(rchar,rcvr_log_fp);
		}
		/* back if log file if not raw and char is backspace */
		else if(!rcvr_log_raw && ((rchar == BS)||(rchar == DEL)))
		{
		long logpos = 0;
			if(logpos = ftell(rcvr_log_fp))
				fseek(rcvr_log_fp,logpos - 1,0);
		}

		if(rcvr_log_flusheach)
			fflush(rcvr_log_fp);
	}
	return(0);

}	/* end of process_rcvd_char */

/*+-----------------------------------------------------------------------
	rcvr() - copy characters from remote line to screen
------------------------------------------------------------------------*/
void
rcvr()
{
	uchar rchar;
	uchar nlchar = NL;

#ifdef ANSI_DEBUG
char s80[80];
	wfp = fopen(ANSI_DEBUG_LOGFILE,"a");
	if(ulindex(ANSI_DEBUG_LOGFILE,"/dev/tty") != -1)
	{
		sprintf(s80,"stty opost ocrnl < %s",ANSI_DEBUG_LOGFILE);
		system(s80);
	}
	fprintf(wfp,"***************\n");
#ifdef ANSI_DEBUG_NOBUF
	setbuf(wfp,NULL);
#endif /* ANSI_DEBUG_NOBUF */
#endif /* ANSI_DEBUG */

	rcvr_pid = getpid();
	shm->autorz_pos = 0;
	lgetc_count = 0;
	in_ansi_accumulation = 0;
	ansi = ansibuf;
	ansilen = 0;
	shm->rcvrdisp_ptr = shm->rcvrdisp_buffer;
	shm->rcvrdisp_count = 0;

/* yetch - magic number gretching for lines and columns */
	if(!tcap_LINES || !tcap_COLS)
	{
		tcap_LINES = 25;
		tcap_COLS = 80;
	}
	if(tcap_LINES > SCREEN_LINES_MAX)
		tcap_LINES = SCREEN_LINES_MAX;
	if(tcap_COLS > SCREEN_COLS_MAX)
		tcap_COLS = SCREEN_COLS_MAX;
	LINESxCOLS = tcap_LINES * tcap_COLS;

	rcvr_signals();
	rcvr_log_open();

	saved_cursor_y = shm->cursor_y;
	saved_cursor_x = shm->cursor_x;

/* receive loop - keep tight as possible! */
	if(tty_is_multiscreen)
	{
		while(1)
		{
			rchar = lgetc_rcvr();

			if(process_rcvd_char(rchar))
				continue;

			rcvrdisp((char *)&rchar,1);

			if(shm->Ladd_nl_incoming && (rchar == CRET))
				rcvrdisp((char *)&nlchar,1);
		}
	}
	else
	{
		while(1)
		{
			rchar = lgetc_rcvr();

			if(rchar >= 0x80)
				rchar = non_multiscreen_hi_map[rchar - 0x80];

			if(process_rcvd_char(rchar))
				continue;

			rcvrdisp((char *)&rchar,1);

			if(shm->Ladd_nl_incoming && (rchar == CRET))
				rcvrdisp((char *)&nlchar,1);
		}
	}
}	/* end of rcvr */

/* end of ecurcvr.c */
/* vi: set tabstop=4 shiftwidth=4: */
