;+------------------------------------------------------------------
; memmove386.asm
;
; Name
;      memmove - Copies characters between objects.
;
; Syntax
;
;      void *memmove(dest, src, count)
;      void *dest;
;      const void *src;
;      size_t count;
;
; Description
;      The memmove function copies count characters from src to
;      dest.  If some regions of src and dest overlap, memmove
;      ensures that the original src bytes in the overlapping
;      region are copied before being overwritten.
;
; Return Value
;      The value of dest, the destination object.
;
;-------------------------------------------------------------------
;+:EDITS:
;:09-10-1992-13:59-wht@n4hgf-ECU release 3.20
;:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA
;:09-01-1991-23:15-wht@n4hgf-convert Chip's memmove.s

	TITLE   memmove286.asm
	.286p
	.287
MEMMOVE_TEXT	SEGMENT  WORD PUBLIC 'CODE'
MEMMOVE_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
DGROUP	GROUP	CONST, _BSS, _DATA
	ASSUME  CS: MEMMOVE_TEXT, DS: DGROUP, SS: DGROUP
EXTRN	__chkstk:FAR
MEMMOVE_TEXT      SEGMENT
	ASSUME	CS: MEMMOVE_TEXT

dest	equ	6
src	equ	10
len	equ	14

	PUBLIC	_memmove
_memmove	PROC FAR
	push	bp
	mov	bp,sp
	mov	ax,0
	call	FAR PTR __chkstk
	push	di
	push	si
	push	ds

	mov	ax,WORD PTR [bp+src]
	mov	dx,WORD PTR [bp+src+2]
	mov	cx,WORD PTR [bp+len]
	mov	si,ax
	mov	ds,dx
	les	di,DWORD PTR [bp+dest]
	mov	dx,es

; which way should the copy go?
	mov	ax,di
	sub	ax,si
	jb	short mm_ascend
	cmp	cx,ax
	jb	short mm_ascend

; descending
	add	si,cx
	dec	si
	add	di,cx
	dec	di
	std
	rep	movsb
	cld
	jmp	short mm_exit

; ascending
mm_ascend:
	cld
	shr	cx,1
	rep	movsw
	adc	cx,cx
	rep	movsb

mm_exit:
	pop	ds
	pop	si
	pop	di
	leave	
	ret	

_memmove  ENDP
_TEXT	ENDS
	end
