;+------------------------------------------------------------------
; memmove386.asm
;
; Name
;      memmove - Copies characters between objects.
;
; Syntax
;
;      void *memmove(dest, src, count)
;      void *dest;
;      const void *src;
;      size_t count;
;
; Description
;      The memmove function copies count characters from src to
;      dest.  If some regions of src and dest overlap, memmove
;      ensures that the original src bytes in the overlapping
;      region are copied before being overwritten.
;
; Return Value
;      The value of dest, the destination object.
;
;-------------------------------------------------------------------
;+:EDITS:
;:09-10-1992-13:59-wht@n4hgf-ECU release 3.20
;:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA
;:09-01-1991-23:15-wht@n4hgf-convert Chip's memmove.s

	TITLE	$memmove

	.386
DGROUP	GROUP	CONST, _BSS, _DATA
_DATA	SEGMENT  DWORD USE32 PUBLIC 'DATA'
_DATA      ENDS
_BSS	SEGMENT  DWORD USE32 PUBLIC 'BSS'
_BSS      ENDS
CONST	SEGMENT  DWORD USE32 PUBLIC 'CONST'
CONST      ENDS
	ASSUME   CS: _TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP

	PUBLIC  _memmove
	PUBLIC  memmove

_TEXT	SEGMENT  DWORD USE32 PUBLIC 'CODE'
_memmove PROC NEAR
memmove:
	push	edi
	push	esi
	mov	edi,[esp+12]
	mov	esi,[esp+16]
	mov	ecx,[esp+20]
	mov	eax,edi		; return value: dest
	jcxz	mm_exit

	mov	edx,edi
	sub	edx,esi
	jb	short mm_left_to_right
	cmp	ecx,edx
	jb	short mm_left_to_right

mm_right_to_left:
	add	edi,ecx
	dec	edi
	add	esi,ecx
	dec	esi
	std
	rep movsb
	cld
	jmp	short mm_exit

mm_left_to_right:
	cld
	mov	edx,ecx
	shr	ecx,2
	rep movsw
	mov	ecx,edx
	and	ecx,3
	rep movsb

mm_exit:
	pop	esi
	pop	edi
	ret
_memmove  ENDP
_TEXT	ENDES
	end
