/*+-------------------------------------------------------------------------
	pc_scr.h - PC/AT screen definitions
	wht@n4hgf.Mt-Park.GA.US
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:03-27-1992-16:21-wht@n4hgf-re-include protection for all .h files */
/*:07-25-1991-12:58-wht@n4hgf-ECU release 3.10 */
/*:12-04-1990-02:48-wht@n4hgf-for nonansi terminals provide either ruling set */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#ifndef _pc_scr_h
#define _pc_scr_h

/*
 * AT ROM ruling characters
 */
#define at_TL		0xDA	/* top left single rule */
#define at_TR		0xBF	/* top right single rule */
#define at_BL		0xC0	/* bottom left single rule */
#define at_BR		0xD9	/* bottom right single rule */
#define at_LT		0xC3	/* left hand T */
#define at_RT		0xB4	/* right hand T */
#define at_VR		0xB3	/* vertical rule */
#define at_HR		0xC4	/* horizontal rule */
/*
 * non-ANSI equivalents
 */
#define vanilla_TL		'.'
#define vanilla_TR		'.'
#define vanilla_BL		'`'
#define vanilla_BR		'\''
#define vanilla_LT		'+'
#define vanilla_RT		'+'
#define vanilla_VR		'|'
#define vanilla_HR		'-'

extern unsigned char sTL;
extern unsigned char sTR;
extern unsigned char sBL;
extern unsigned char sBR;
extern unsigned char sLT;
extern unsigned char sRT;
extern unsigned char sVR;
extern unsigned char sHR;

#endif /* _pc_scr_h */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of pc_scr.h */
