#if defined(SHARE_DEBUG)
#define LOG_UTMP
#endif
/*+-------------------------------------------------------------------------
	utmpstat.c - utmp status for XENIX/UNIX line
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	strcmpi(s1,s2)
	to_lower(ch)
	to_upper(ch)
	utmp_status(line)

                   system boot         0 Fri Apr 24 07:18:52 1992
                   run-level 2         0 Fri Apr 24 07:18:52 1992
asktimerck ck                         15 Fri Apr 24 07:19:38 1992
cat        copy                       17 Fri Apr 24 07:19:38 1992
brc        brc                        18 Fri Apr 24 07:19:39 1992
brc        mt                         22 Fri Apr 24 07:19:39 1992
authckrcac ack                        26 Fri Apr 24 07:19:39 1992
rc2        r2                         27 Fri Apr 24 07:20:05 1992
LOGIN      co      tty01             170 Fri Apr 24 07:20:09 1992
LOGIN      c02     tty02             171 Fri Apr 24 07:20:09 1992
uugetty    u2B     tty2B            3837 Fri Apr 24 21:24:38 1992
uugetty    u2h                       190 Fri Apr 24 07:20:08 1992
uugetty    u1A                      3830 Fri Apr 24 21:24:10 1992
wht        p0      ttyp0             206 Fri Apr 24 07:20:43 1992
wht        p1      ttyp1            1515 Fri Apr 24 20:55:53 1992
wht        p2      ttyp2            2929 Fri Apr 24 20:55:45 1992

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:09-02-1992-14:18-wht@n4hgf-some mark dead utmp entries instead of rming */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:06-30-1992-14:46-wht@n4hgf-honor DIALOUT set by 3.2v4 getty when we lock */
/*:04-28-1992-03:58-wht@n4hgf-check SCO utmp entry against ut_id */
/*:04-24-1992-21:59-wht@n4hgf-more SCO tty name normalizing */
/*:11-08-1991-21:09-root@n4hgf-bug in strcmpi made for erratic return value */
/*:08-25-1991-14:39-wht@n4hgf-SVR4 port thanks to aega84!lh */
/*:08-21-1991-02:23-wht@n4hgf-sun port */
/*:08-10-1991-17:39-wht@n4hgf-US_WEGOTIT handling */
/*:07-25-1991-12:59-wht@n4hgf-ECU release 3.10 */
/*:02-13-1991-02:00-ache@hq.demos.su-swap patch 5 US_ return values */
/*:02-07-1991-00:28-wht@n4hgf-utmp_status() was really messed up */
/*:02-03-1991-17:52-ache@hq.demos.su-fix for XENIX utmp handling bug */
/*:10-16-1990-20:43-wht@n4hgf-add SHARE_DEBUG */
/*:09-19-1990-19:36-wht@n4hgf-ecu_log_event now gets pid for log from caller */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "termecu.h"
#include "utmpstatus.h"
#include "ecuungetty.h"
#include "dialprog.h"
#include <errno.h>
#include <utmp.h>

#if defined(sun)
#define ut_id ut_host		/* fake debug info */
#else
#if !defined(ut_name)		/* nobody can keep their mind made up; ... */
#define ut_name ut_user		/* ... this is getting verry difficult, very old */
#endif
#endif /* sun */

#if defined(SVR4)
char *utmp_file = "/var/adm/utmp";
#else
char *utmp_file = "/etc/utmp";
#endif

struct utmp last_utmp;

/*+-------------------------------------------------------------------------
    to_upper() / to_lower()

One would think that these were relatively standard types of
thing, but System V specifies toupper() to convert to upper case
if not already and BSD says to adjust without testing, so, two
stupid little routines here.  ASCII only -- no EBCDIC gradoo here please.
--------------------------------------------------------------------------*/
char to_upper(ch)
register char ch;
{ return( ((ch >= 'a') && (ch <= 'z')) ? ch - 0x20 : ch);
}   /* end of to_upper() */

char to_lower(ch)
register char ch;
{ return( ((ch >= 'A') && (ch <= 'Z')) ? ch + 0x20 : ch);
}   /* end of to_lower() */

/*+-------------------------------------------------------------------------
	strcmpi(s1,s2) - case-insensitive strcmp

This version of strcmp() is case-insensitive and works like a sane one
should, per strcmp(3), not per  the K&R1 example or POSIX/ANSI.

In here rather than ecuutil.c since other executables besides ecu
uses this module and strcmpi needed there too 
--------------------------------------------------------------------------*/
int
strcmpi(s1,s2)
register char *s1;
register char *s2;
{

    while(*s1)
	{
        if(to_upper(*s1++) != to_upper(*s2++))
		{
			s1--;
			s2--;
            break;
		}
	}
	return(to_upper(*s1) - to_upper(*s2));

}	/* end of strcmpi */

/*+-------------------------------------------------------------------------
	utmp_status(line) - check line status in utmp
'line' is "/dev/ttyxx"-style
returns US_ value and global utmp struct last_utmp;
--------------------------------------------------------------------------*/
int
utmp_status(line)
char *line;
{
#ifdef sun
	return(US_NOTFOUND);
#else
	register itmp;
	register status = US_NOTFOUND;
	register ufd;
#if defined(LOG_UTMP)
	char logstr[128];
#endif

/*
 * crock/bozo alert: 
 * ut_name ain't but EIGHT characters long, but
 * EIGHT characters are often stored, so ya don't get no null
 * ut_id ain't but FOUR characters long, but
 * FOUR characters are routinely stored, so ya don't get no null
 */
	char namecopy[sizeof(last_utmp.ut_name) + 1];
	char idcopy[sizeof(last_utmp.ut_id) + 1];

	if((ufd = open(utmp_file,O_RDONLY,755)) < 0)
	{
		perror(utmp_file);
		termecu(TERMECU_LINE_OPEN_ERROR);
	}

	while((status == US_NOTFOUND) &&
		(read(ufd,(char *)&last_utmp,sizeof(last_utmp)) == sizeof(last_utmp)))
	{
		strncpy(namecopy,last_utmp.ut_name,sizeof(last_utmp.ut_name));
		namecopy[sizeof(last_utmp.ut_name)] = 0;

		strncpy(idcopy,last_utmp.ut_id,sizeof(last_utmp.ut_id));
		idcopy[sizeof(last_utmp.ut_id)] = 0;

	    if(!last_utmp.ut_line[0] || TTYNAME_STRCMP(last_utmp.ut_line,line + 5))
		{
#ifdef M_SYSV
			/*
			 * yetch! SCO uugetty doesn't always plug tty field !!!!
			 * So we count on a convention of the last two characters
			 * match the last two characters of the id field
			 */
			int itmp2;
			if( !last_utmp.ut_line[0] &&
				((itmp = strlen(line)) > 2) &&
				((itmp2 = strlen(idcopy)) > 2) &&
				!strcmpi(line + itmp - 2,idcopy + itmp2 - 2))
			{
				if(itmp = line_lock_status(line))
				{
					if(itmp == LINST_WEGOTIT)
						status = US_WEGOTIT;
					else
						status = US_DIALOUT;
				}
				else if(!kill(last_utmp.ut_pid,0) || (errno == ESRCH))
					status = US_LOGIN;
				else
					status = US_NOTFOUND;
				break;
			}
#endif
			continue;
		}

	    if(!strcmp(namecopy,"LOGIN"))
		{
			if(!kill(last_utmp.ut_pid,0) || (errno == ESRCH))
				status = US_LOGIN;
			else
				status = US_NOTFOUND;
		}
	    else if(!strcmp(namecopy,"DIALOUT"))
		{
			status = US_DIALOUT;
			if(last_utmp.ut_pid == xmtr_pid)
				status = US_WEGOTIT;
			else if(line_lock_status(line) == LINST_WEGOTIT)
				status = US_WEGOTIT;
		}
	    else if((!strcmp(namecopy,"uugetty") || !strcmp(namecopy,"getty")))
		{
			if(itmp = line_lock_status(line))
			{
				if(itmp == LINST_WEGOTIT)
					status = US_WEGOTIT;
				else
					status = US_DIALOUT;
			}
			else if(!kill(last_utmp.ut_pid,0) || (errno == ESRCH))
				status = US_LOGIN;
			else
				status = US_NOTFOUND;
		}
		else if(!kill((PID_T)last_utmp.ut_pid,0) || (errno != ESRCH))
			status = (last_utmp.ut_pid == xmtr_pid) ? US_WEGOTIT : US_LOGGEDIN;
	}

#if defined(LOG_UTMP)
	if(status == US_NOTFOUND)
		sprintf(logstr,"UTMP %s: no entry in utmp, status=%d",line,status);
	else
	{
	char *ctime();
		sprintf(logstr,"UTMP %s:%s:%s:%d:%d",
		    namecopy,idcopy,last_utmp.ut_line,last_utmp.ut_pid,status);
	}
	ecu_log_event(getpid(),logstr);
#endif

	close(ufd);
	return(status);
#endif  /* sun */

}	/* end of utmp_status */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of utmpstat.c */
