#ifndef _EFAXLIB_H
#define _EFAXLIB_H

#ifndef u_char
#define u_char unsigned char
#endif

#ifndef FILENAME_MAX
#define FILENAME_MAX 255
#endif

#define DEFPGLINES 66           /* default lines per page */
#define LOGF stderr      	/* session log written to this stream */


		    /* Messages & Program Arguments */

enum  cchar {				/* control characters */
  NUL, SOH, STX, ETX, EOT, ENQ, ACK, BEL, BS,  HT,  LF,
  VT,  FF,  CR,  SO,  SI,  DLE, XON, DC2, XOFF,DC4, NAK,
  SYN, ETB, CAN, EM,  SUB, ESC, FS,  GS,  RS,  US } ;

extern char *verb ;		/* types of messages to print */
extern char *argv0 ;		/* program name */
char *cname ( unsigned char c ) ;
int msg ( const char *fmt, ... ) ;

extern int optind ;
extern char *optarg ;
int nextopt( int argc, char **argv, char *args ) ;

			   /* Buffer sizes.  */

/* The maximum scan line width, MAXRUNS, is conservatively
   set at 8k pels. This is enough for the longest standard T.4 coding line
   width (2432 pels), the longest encodeable run (2623 pels) and with
   32-pel-wide characters allows up to 256 characters per line.  Converted
   to T.4 codes, each pair of runs takes up to 25 bits to code.  MAXCODES
   must also be at least the maximum minimum line length (1200 cps*40 ms ~=
   48 bytes).  */

#define MAXRUNS 8192
#define MAXBITS (MAXRUNS/8+1)
#define MAXCODES (MAXRUNS*25/8/2+1)

/* Line/font size limits */

#define MAXLINELEN 256				/* maximum length of string */
#define MAXFONTW 32				/* maximum char width */
#define MAXFONTH 48				/* maximum char height */
#define MAXFONTBUF (MAXFONTW*MAXFONTH/8*256) 	/* PBM font buffer size */

/* Longest run encodeable by the T.4 encoding tables used. */

#define MAXRUNLEN (2560+63)

	       /* Codes for EOL and EOLs required for RTC */

#define EOLCODE 1
#define EOLBITS 12
#define RTCEOL  5
				/* Fonts */

#define STDFONTW    8		/* the built-in font width, height & size */
#define STDFONTH    16
#define STDFONTBUF  4096

typedef struct fontstruct {
  int h, w ;
  u_char buf [ MAXFONTBUF ] ;
  short offset [ 256 ] ;
} pbmfont ;

extern u_char stdfont [ ] ;	/* compressed bit map for built-in font */

int readfont ( char *fname, pbmfont *font ) ;

		    /* T.4 Encoding/Decoding */

typedef struct t4tabstruct { 
  short code, bits, rlen ;			/* code, bits, run length */
} t4tab ;

extern t4tab wtab [ ( 64 + 27 + 13 ) + 1 ] ;	/* white runs */
extern t4tab btab [ ( 64 + 27 + 13 ) + 1 ] ;	/* black runs */

typedef struct dtabstruct {			/* decoder table entry */
  struct dtabstruct *next ;
  short bits, code ;
} dtab ;

			     /* Image Input */

enum formats { TEXT=0, PBM=1, FAX=2, PCL=3, PS=4, PGM=5 } ;

typedef struct decoderstruct {
  long x ;				 /* undecoded bits */
  short shift ;				 /* number of unused bits - 9 */
  dtab *tab ;				 /* current decoding table */
  int eolcnt ;				 /* EOL count for detecting RTC */
} DECODER ;

void newDECODER ( DECODER *d ) ;

typedef struct ifilestruct {		 /* input image file state  */
  FILE *f ;				 /* file pointer */
  int format ;				 /* file format */
  char **fname ;			 /* list of file names */
  int lines ;			         /* scan lines left in page */
  long start ;				 /* start of page in current file */
  pbmfont *font ;			 /* TEXT: font to use */
  int pglines ;				 /* TEXT: text lines per page */
  char text [ MAXLINELEN ] ;		 /* TEXT: current string */
  int txtlines ;			 /* TEXT: scan lines left in text l. */
  int w, h, Bw ;			 /* PBM: bytes to read per line */
  DECODER d ;			         /* FAX: T.4 decoder state */
} IFILE ;

int openpbm ( FILE *f, int *w, int *h ) ;
void    newIFILE ( IFILE *f, int format, char **fname ) ;
IFILE *nextipage ( IFILE *f, int dp ) ;
int     readline ( IFILE *f, short *runs, int *pels ) ;

			    /* Image Output */

typedef struct encoderstruct {
  long x ;				 /* unused bits */
  short shift ;				 /* number of unused bits - 8 */
} ENCODER ;

void newENCODER ( ENCODER *e ) ;

typedef struct ofilestruct {		 /* input image file state  */
  FILE *f ;				 /* file pointer */
  int format ;				 /* file format */
  char *fname ;			         /* file name pattern */
  char cfname [ FILENAME_MAX + 1 ] ;	 /* current file name */
  float xres, yres ;			 /* x and y resolution, dpi */
  int w, h ;			         /* width & height, pixels */
  int lastpageno ;			 /* PS: last page number this file */
  int firstpsline ;			 /* PS: first line scan line of file */
  ENCODER e ;				 /* T.4 encoder state */
} OFILE ;

void  newOFILE ( OFILE *f, int format, char *fname, 
		float xres, float yres, int w, int h ) ;
int  nextopage ( OFILE *f, int page ) ;
void writeline ( OFILE *f, short *runs, int nr, int no ) ;

			/*  Scan Line Processing */

u_char   *putcode ( ENCODER *e, short code , short bits , u_char *buf ) ;
u_char *runtocode ( ENCODER *e, short *runs, int nr, u_char *buf ) ;

/* int bittorun ( u_char *buf, int n, short *runs ) ; */
int texttorun ( u_char *txt, pbmfont *font, 
	       short line, short *runs, int *pels ) ;

int   xpad ( short *runs, int nr, int pad ) ;
int xscale ( short *runs, int nr, int xs ) ;
int xshift ( short *runs, int nr, int s ) ;

int runor ( short *a, int na, short *b, int nb, short *c, int *pels ) ;

#endif
