/*
   qdel.c - Queue item deleter for Renaissoft Qfax 1.0
   (c) 1994 Robert LeBlanc and Renaissoft
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "qfax.h"

void main(int argc, char *argv[])
{
  int i, faxes, killall;
  char cmdlist[MAXFAXES][LINELEN];
  char cmd[LINELEN];
  char dialstring[PHONELEN];
  char recipient[LONGLEN];
  char subject[LONGLEN];
  char prefix[LONGLEN];
  char shortprefix[LONGLEN];
  char user[ALIASLEN];
  char sender[ALIASLEN];
  char *ptr;

  if (argc < 2) {
    printf("Usage: qdel [ -a | prefix ]\n\n");
    printf("Use qstat to find the prefix of the fax you want to delete.\n");
    printf("\n");
    exit(EXIT_FAILURE);
  }
  killall = (strcasecmp(argv[1], "-a") == 0);
  faxes = make_cmdlist(cmdlist);
  if (!faxes) {
    printf("No entries.\n");
    exit(EXIT_SUCCESS);
  }
  for (i=0; i < faxes; i++) {
    get_cmdinfo(cmdlist[i], dialstring, recipient, subject);
    strcpy(prefix, make_prefix(cmdlist[i]));
    ptr = strrchr(prefix, '/');
    strcpy(shortprefix, (++ptr));
    strcpy(sender, get_sender(prefix));
    strcpy(user, getenv("USER"));
    if (killall || (strcasecmp(shortprefix, argv[1]) == 0)) {
      if ((strcasecmp(user, "root") == 0) || (strcasecmp(user, sender) == 0)) {
        sprintf(cmd, "rm -f %s*", prefix);
        system(cmd);
        printf("Removed fax %s\n", prefix);
      } else {
	printf("%s : Permission denied.\n", prefix);
      }
    }
  }
  exit(EXIT_SUCCESS);
}




