/*
 * Pcomm script commands.  Since these will be executed from a forked
 * shell script, the commands, queries, and responses are sent thru an
 * IPC channel to Pcomm.
 */

#include <stdio.h>
#include <curses.h>
#include "cmd.h"
#include "config.h"
#include "dial_dir.h"
#include "extrnl.h"
#include "modem.h"
#include "param.h"
#include "status.h"
#include "xmodem.h"

static void send_reply(), do_xfer(), cmode(), tmode();

void
cmd_input()
{
	extern int fd;
	int cmd, arg1, i, n, ret_code;
	char buf[256], *s, arg2[256], *strchr(), *str_rep();
	char *entry, *strtok(), ld_code;
	void hang_up(), line_set(), pexit(), screen_dump();

	if (ipc_read(status->cmd_ipc, buf, 256))
		return;

					/* parse the comand line */
	if (sscanf(buf, "%d %d %s\n", &cmd, &arg1, arg2) != 3)
		return;

	ret_code = 0;
	switch(cmd) {
		case SET:		/* the SET command */
			switch(arg1) {
				case BAUD:	
					dir->baud[0] = (unsigned int) atoi(arg2);
					line_set();
					break;
				case PARITY:
					dir->parity[0] = arg2[0];
					line_set();
					break;
				case DATA_BITS:
					dir->data_bits[0] = atoi(arg2);
					line_set();
					break;
				case STOP_BITS:
					dir->stop_bits[0] = atoi(arg2);
					line_set();
					break;
				case DUPLEX:
					dir->duplex[0] = arg2[0];
					line_set();
					break;
				case AUX:
					dir->aux[0] = str_rep(dir->aux[0], arg2);
					break;
				case HOT_KEY:
					param->hot_key = atoi(arg2);
					break;
				case ASCII_HOT:
					param->ascii_hot = str_rep(param->ascii_hot, arg2);
					break;
				case FLOW_CTRL:
					param->flow_ctrl = str_rep(param->flow_ctrl, arg2);
					break;
				case CR_IN:	
					param->cr_in = str_rep(param->cr_in, arg2);
					break;
				case CR_OUT:
					param->cr_out = str_rep(param->cr_out, arg2);
					break;
				case LOGFILE:
					param->logfile = str_rep(param->logfile, arg2);
					break;
				case DUMPFILE:
					param->dumpfile = str_rep(param->dumpfile, arg2);
					break;
				case STRIP:	
					param->strip = str_rep(param->strip, arg2);
					break;
				case LOCAL_ECHO:	
					param->local_echo = str_rep(param->local_echo, arg2);
					break;
				case EXPAND:
					param->expand = str_rep(param->expand, arg2);
					break;
				case CR_DELAY:
					param->cr_delay = atoi(arg2);
					break;
				case PACE:
					param->pace = str_rep(param->pace, arg2);
					break;
				case CR_UP:
					param->cr_up = str_rep(param->cr_up, arg2);
					break;
				case LF_UP:
					param->lf_up = str_rep(param->lf_up, arg2);
					break;
				case TIMER:
					param->timer = atoi(arg2);
					break;
				case CR_DN:
					param->cr_dn = str_rep(param->cr_dn, arg2);
					break;
				case LF_DN:	
					param->lf_dn = str_rep(param->lf_dn, arg2);
					break;
				default:
					break;
			}
			break;
		case QUERY:		/* the QUERY commands */
			switch(arg1) {
				case TTY_NAME:
					if (modem->t_cur != -1)
						send_reply(modem->tty[modem->t_cur]);
					else
						send_reply("NONE");
					ret_code = 99;
					break;
				case MODEM_NAME:
					if (modem->m_cur != -1)
						send_reply(modem->mname[modem->m_cur]);
					else
						send_reply("NONE");
					ret_code = 99;
					break;
				default:
					break;
			}
			break;
		case IF:		/* the IF commands */
			switch(arg1) {
				case CONNECTED:
					if (status->connected)
						ret_code = 1;
					break;
				case LOG_STATUS:
					if (status->log_status)
						ret_code = 1;
					break;
				case PRINTER_STATUS:
					if (status->print_status)
						ret_code = 1;
					break;
				default:
					break;
			}
			break;
		case DIAL:
			cmode();
			ld_code = '\0';
			s = arg2;
			if (strchr("+-@#", *s)) {
				ld_code = *s;
				s++;
			}

			if (arg1 == 1) {	/* manual dial */
				dir->name[0] = str_rep(dir->number[0], s);
				dir->number[0] = str_rep(dir->number[0], s);
				dir->d_cur = 0;
				dir->q_num[0] = 0;
			}
			else {
				n = atoi(s);
				if (n == 0 || n > NUM_DIR) {
					tmode();
					break;
				}

				dir->d_cur = n;
				dir->q_num[0] = n;
			}
			dir->q_ld[0] = ld_code;
			dir->q_num[1] = -1;
			ret_code = dial_win(1);
			tmode();
			break;
		case REDIAL:
			cmode();
			entry = strtok(arg2, " ");
			for (i=0; i<NUM_QUEUE; i++) {
				if (entry == NULL) {
					dir->q_num[i] = -1;
					break;
				}

				ld_code = '\0';
				if (strchr("+-@#", *entry)) {
					ld_code = *entry;
					entry++;
				}

				n = atoi(entry);
				if (n > NUM_DIR || *dir->number[n] == '\0')
					continue;

				dir->q_ld[i] = ld_code;
				dir->q_num[i] = n;
				entry = strtok((char *) NULL, " \t");
			}
			ret_code = dial_win(10);
			tmode();
			break;
		case EXIT:
			pexit();
			break;
		case CLEAR_SCREEN:
			fixterm();
			erase();
			refresh();
			resetterm();
			break;
		case CHG_DIR:
			chdir(arg2);
			break;
		case HANG_UP:
			hang_up(QUIET);
			break;
		case PRINTER:
			status->print_status = arg1;
			break;
		case MODEM_BREAK:
			tty_break(fd);
			break;
		case SEND:
			do_xfer(arg1, UP_LOAD, arg2);
			break;
		case RECEIVE:
			do_xfer(arg1, DOWN_LOAD, arg2);
			break;
		case SCREEN_DUMP:
			screen_dump();
			break;
		case DATA_LOG:
			status->log_status = arg1;
			break;
		default:
			break;
	}
	if (ret_code != 99) {
		sprintf(buf, "%d", ret_code);
		send_reply(buf);
	}
	return;
}

/*
 * Send a string back to pcomm_cmd
 */

static void
send_reply(s)
char *s;
{
	char buf[256];

	sprintf(buf, "%254.254s\n", s);
	if (ipc_write(status->cmd_ipc, buf, 256))
		fprintf(stderr, "Can't write to IPC\n");
	return;
}

/*
 * Put the screen in the "curses" mode
 */

static void
cmode()
{
	void load_vs(), st_line();

	fixterm();
	load_vs();
	st_line("");
	return;
}

/*
 * Put the screen in the "terminal" mode
 */

static void
tmode()
{
	extern int fd;
	void term_mode();

	if (fd != -1) {
		touchwin(stdscr);
		refresh();
	}
	resetterm();
	term_mode();
	return;
}

/*
 * Do the file transfers
 */

static void
do_xfer(type, up, files)
int type, up;
char *files;
{
	int n, is_batch, num_extrnl;
	char buf[256], *strcpy(), *strcat();
	void xfer_win(), xfer_ascii(), do_extrnl();

	num_extrnl = (up == UP_LOAD) ? extrnl->up_entries : extrnl->dn_entries;
	
	is_batch = 0;
	switch(type) {
		case MODEM7:
		case YMODEM:
		case YMODEM_G:		/* built-in batch protocols */
			is_batch++;
			/* FALLTHRU */
		case XMODEM:
		case XMODEM_1k:		/* non-batch built-ins */
			cmode();
			if (up == UP_LOAD || !is_batch)
				xfer_win(files, up, type);
			else
				xfer_win("", up, type);
			tmode();
			break;
		case XASCII:		/* ascii xfer, yuck! */
			xfer_ascii(files, up);
			break;
		case EXT_1:
		case EXT_2:
		case EXT_3:		/* one of the externals */
			n = type -NUM_INTERNAL -1;
			if (n > num_extrnl)
				break;
			strcpy(buf, extrnl->command[up][n]);
					/* see if we need to add files */
			if (extrnl->prompt[up][n] == 'Y') {
				strcat(buf, " ");
				strcat(buf, files);
			}
			do_extrnl(buf);
			break;
		default:
			break;
	}
	return;
}
