/*
 * Spawn a shell with the stdin and stdout swapped with the remote
 * system, ie:
 *                               +----------+
 *    TTYin ------------> stdin  |          |
 *                               |  shell   |
 *    TTYout <---------- stdout  |          |
 *                               +----------+
 *
 * An undocumented feature:  The external protocol gateway
 * can be used to pipe the output of a normal Unix command to the
 * remote system.
 */

#include <stdio.h>
#include <curses.h>
#include <signal.h>
#include <sys/wait.h>
#include <errno.h>
#include "config.h"

void
do_extrnl(cmd)
char *cmd;
{
	extern int fd, errno;
	WINDOW *xt_win, *newwin();
	int epid, want_out, dummy;
	unsigned int sleep();
	void _exit(), line_set();

					/* a full window */
	xt_win = newwin(LINES, COLS, 0, 0);
	nl();
	touchwin(xt_win);
	wrefresh(xt_win);

	if (!(epid = fork())) {
					/* create a new process group ID */
#ifdef BSD
		setpgrp(0, getpid());
#else /* BSD */
		setpgrp();
#endif /* BSD */
					/* swap the stdin and stdout */
		close(0);
		dup(fd);
		close(1);
		dup(fd);

		setgid(getgid());
		setuid(getuid());

		execl("/bin/sh", "sh", "-c", cmd, (char *) 0);
		_exit(1);
	}

	/*
	 * Check the keyboard while the external program is running.  If
	 * the user hits the <ESC> key, then kill the entire process
	 * group associated with the new shell.
	 */
	want_out = 0;
	/* CONSTCOND */
	while(1) {
		switch(wait_key(stdscr, 1)) {
			case -1:	/* timed out */
				break;
			case 27:	/* a user abort */
#ifdef BSD
				killpg(epid, SIGKILL);
#else /* BSD */
				kill(-epid, SIGKILL);
#endif /* BSD */
				want_out++;
				break;
			default:
				beep();
				break;
		}
		if (want_out)
			break;

#ifdef linux
		if (waitpid(epid, &dummy, WNOHANG) == epid)
			break;
#else
		/* see if the process it still active */
#ifdef BSD
		if ((kill(epid, 0) == -1) && errno == ESRCH) 
#else /* BSD */
		/* Under Linux: */
		/* kill(-epid, 0) returns 0 even if the process is dead ! */
		if ((kill(-epid, 0) == -1) && errno == ESRCH) 
#endif /* BSD */
			break;
#endif
	}
#ifndef linux
					/* no zombies please */
	wait(&dummy);
#endif
					/* the tty may have been clobbered */
	beep(); beep(); beep();
	sleep(1);
	fixterm();
	line_set();
	nonl();

	clearok(curscr, TRUE);
	werase(xt_win);
	wrefresh(xt_win);
	delwin(xt_win);
	return;
}
