
/* normalize file name, assume *filn is at least 128 chars */
char *
getfname( char *filn, int strpflg )
{
	char *wtp, *utp ;

	wtp = filn ;
	utp = wtp + 128 ; /*!! debug: fix the 128 thingy */

	while ( *wtp == 0x20 ) { 	/* strip leading spaces */
		wtp++ ;
		if ( wtp == utp )
		    return 0 ; 		/* just spaces, no file name */
	}
	if ( ! filn[0] || ! wtp[0] )
		return 0 ; 		/* empty string */
	if ( *wtp == '.' )
		while( *++wtp == '/' ) 
			; /* increment pointer beyond '/' character */ 

	/* normalize string:  strip trailing '/' and so on */ 
#if 0
	for(;;){
		if((utp = strrchr( wtp, '/' )) != NULL) {
			if ( strpflg ) {   
				wtp = utp + 1 ;	/* strip path */
			}
			if ( utp[1] == 0 ) {
				return 0 ;  /* no file name */
			}
			else
				break ;
				
		}  
		else 
			break ;
		
	}
#endif
	if((utp = strrchr( wtp, '/' )) != NULL) {
		if ( strpflg ) {   
			wtp = utp + 1 ;	/* strip path */
		}
		if ( utp[1] == 0 ) {
			return 0 ;  /* no file name */
		}
	}
	return wtp ;
}


int
build_hdr()
{
	int retcode = 0, i = 0;
	struct stat sbuf ;
	char *fname, *tpr = wcbuf ;

        while ( i < SECSIZ ) tpr[i] = 0, i++ ;  /* clear buffer */
	getword();
	fname = getfname( word, TRUE );

	if ( fname )
	{
		if ( stat( word, &sbuf ))
		{
			perror( fname );
			fprintf( stderr, "\rCan't stat()  %s\n\r", fname );
			retcode = -1 ;
		}
		else
		{
			smallhdr = TRUE ;
			strcpy( wcbuf, fname );
			while( *tpr ) tpr++ ; tpr++ ; 
			sprintf(tpr,"%ld %lo %o", sbuf.st_size, sbuf.st_mtime, sbuf.st_mode);
			fprintf(stderr,"%s %ld %-25o\n\r", fname, sbuf.st_size, sbuf.st_mode);
			while( *tpr ) tpr++ ;
			if ( 128 < (tpr - wcbuf) ) smallhdr = FALSE ;
		}	
	}
	else 
	{
		y_done = smallhdr = TRUE ;
	}
	return retcode ;
}



void
ysend( int e )
{
    y_done = FALSE ;
    oldvec = signal (SIGINT, xmsigint);

    if (setmode ('b'))
      {
	
	  g_flag = FALSE ; /* only receiver can set g_flag */
	  sprintf (Msg, "Sending %s", ksecsize == 128 ? "128 byte small packet YMODEM"
	          : "1K byte packets YMODEM  ") ; show(1,Msg) ;
	  if (!setjmp (our_env))
	    {
		while( !y_done )
		{
			if( !build_hdr() ) 
			{
				if (wctx () == ERROR)
		  		{
		      		sprintf (Msg, "Error transmitting file %s", word);
		      		show(1,Msg) ;
		      		purge(); 
				y_done = TRUE ;
		      		/* return; why isn't signal restored? *??*/
		  		}
			}
		}
	    }
      }
    signal (SIGINT, oldvec);
    g_flag = smallhdr = FALSE ;
}

/* re-set the date and perms of a file received via ymodem */
void
set_dp( const char *name_fl, const time_t time_fl, const unsigned long perm_fl )
{
	struct utimbuf utb ;

	if ( name_fl != NULL ) {
		if ( time_fl != 0 ) {
			utb.actime = utb.modtime = time_fl ;
			if ( utime( name_fl, &utb ))
				perror(name_fl);
		}
		if ( perm_fl != 0 ) {
			if ( chmod( name_fl, (mode_t) perm_fl ))
				perror(name_fl);
		}
	}

}


/* parse ymodem header for file name and attributes */

static int
yparse()
{
	int i = 0 ;
	char *wtp, *utp ;

	phdr.fnam = NULL ;
	phdr.fsiz = 0 ;
	phdr.fdat = 0 ;
	phdr.fprm = 0 ;

	while ( i < 128 && wcbuf[i] ) i++ ;	/*!! fix the 128 thingy!*/
	if ( i == 0 || i >= ksecsize ) {
		y_done = TRUE ;
		return OK ;
	}
	/* need some error checking here: */
        utp = getfname( wcbuf, TRUE );	
	strcpy ( Name, utp );	
	phdr.fnam = Name ;
	if ( (xfp = QueryCreate (Resume_Not_Allowed)) == NULL) {
		return (ERROR);			/* can't open file */
	}
	while ( *utp != 0 ) utp++ ; utp++ ;	/* point to start of len*/ 
	phdr.fsiz = strtol( utp, &wtp, 10 ); 	/* get file length 	*/
	if ( *wtp == 0x20 ) { 			/* file date is included */
		phdr.fdat = strtol( wtp, &utp, 8 );
		if ( *utp == 0x20 ){
			phdr.fprm = strtoul( utp, &wtp, 8 ) & 07777 ;
			*wtp = 0 ; /* terminate string */
		} 
	}
	cl_line();
	sprintf(Msg,"%s %ld %s",phdr.fnam, phdr.fsiz,(phdr.fprm ? utp : " ")); 
	fprintf(stderr,"\r%s\n\r",Msg);
	return OK ;

}


void
yreceive( int e )
{
    y_done = FALSE ;
    oldvec = signal (SIGINT, xmsigint);
    
    purge(); /*!!*/
    if (setmode ('b'))
    {
	  if (!setjmp (our_env))
	    {
    		g_flag = e == 'g' ? TRUE : FALSE ; 
		while( y_done == FALSE )
		{
			if (wcrx () == ERROR)
			{
			cl_line();
			sprintf (Msg, "Error receiving file %s", word);
			show(1,Msg) ;
			purge(); 
			y_done = TRUE ;
			/* return; why isn't signal restored? *??*/
			}
		}
	    }
      }
    signal (SIGINT, oldvec);
    g_flag = smallhdr = FALSE ;
}
